% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliography.R
\name{bibliography_entries}
\alias{bibliography_entries}
\title{Print bibliography section}
\usage{
bibliography_entries(file, startlabel = NULL, endlabel = NULL)
}
\arguments{
\item{file}{A path to a bibliography file understood by \code{\link[rmarkdown:pandoc_citeproc_convert]{rmarkdown::pandoc_citeproc_convert()}}.}

\item{startlabel}{Defunct.}

\item{endlabel}{Defunct.}
}
\value{
A dataset representing the bibliographic entries, suitable for
generating a reference section in a document.
}
\description{
Given a bibliography file, this function will generate bibliographic entries
for one or more types of bib entry.
}
\examples{
if (rmarkdown::pandoc_available("2.7")) {

# Create a bibliography from a set of packages
bib <- tempfile(fileext = ".bib")
knitr::write_bib(c("vitae", "tibble"), bib)

# Import the bibliography entries into a CV
bibliography_entries(bib)

# The order of these entries can be customised using `dplyr::arrange()`
bibliography_entries(bib) \%>\%
  arrange(desc(title))

# For more complex fields like author, you can also sort by component fields.
# For example, use `author$family` to sort by family names.
bibliography_entries(bib) \%>\%
  arrange(desc(author$family))

}
}
\author{
Mitchell O'Hara-Wild & Rob J Hyndman
}
