% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_habit.R
\name{identify_habit}
\alias{identify_habit}
\title{Identify whether a habitual behaviour exists over a given interval of time}
\usage{
identify_habit(
  data,
  metric,
  threshold = 1,
  width,
  max_window,
  hrvar = NULL,
  return = "plot",
  plot_mode = "time"
)
}
\arguments{
\item{data}{Data frame containing Person Query to be analysed. The data frame
must have a \code{PersonId}, \code{MetricDate} and a column containing a metric for
classifying behaviour.}

\item{metric}{Character string specifying the metric to be analysed.}

\item{threshold}{Numeric value specifying the minimum number of times the
metric sum up to in order to be a valid count. A 'greater than or equal to'
logic is used.}

\item{width}{Integer specifying the number of qualifying counts to consider
for a habit. The function assumes a \strong{weekly} interval is used.}

\item{max_window}{Integer specifying the maximum unit of dates to consider a
qualifying window for a habit. If your data is grouped at a weekly level,
then \code{max_window = 12} would consider 12 weeks.}

\item{hrvar}{Character string specifying the HR attribute or organisational
variable to group by. Default is \code{NULL}.}

\item{return}{Character string specifying the type of output to be returned.
Valid options include:
\itemize{
\item \code{"data"}: Returns the data frame with the habit classification.
\item \code{"plot"}: Returns a ggplot object of a boxplot, showing the percentage of
periods with where habitual behaviour occurred.
\item \code{"summary"}: Returns a summary table of the habit analysis.
}}

\item{plot_mode}{Character string specifying the type of plot to be returned.
Only applicable when \code{return = "plot"}. Valid options include:
\itemize{
\item \code{"time"}: Returns a time series plot with the breakdown of users with
habitual behaviour.
\item \code{"boxplot"}: Returns a boxplot of the percentage of periods with habitual
behaviour.
}}
}
\description{
Based on the principle of consistency, this function identifies whether a
habit exists over a given interval of time. A habit is defined as a behaviour
(action taken) that is repeated at least x number of times consistently over
n weeks.
}
\details{
Each week is considered as a binary variable on whether sufficient action has
been taken for that given week (a qualifying count). Sufficiency is
determined by the \code{threshold} parameter. For instance, if the threshold is
set to 2, this means that there must be 2 qualifying actions (e.g. summarise
meeting in Copilot) in a week for there to be a qualifying count for the
week.
One way of determining the parameters would be to consider, \emph{how many counts
of \code{width} should occur within a \code{max_window} period for it to be considered
a habit?}
}
\examples{
# Return a plot
identify_habit(
  pq_data,
  metric = "Multitasking_hours",
  threshold = 1,
  width = 9,
  max_window = 12,
  return = "plot"
)

# Return a summary
identify_habit(
  pq_data,
  metric = "Multitasking_hours",
  threshold = 1,
  width = 9,
  max_window = 12,
  return = "summary"
)

}
