% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vip2vivid.R
\name{vip2vivid}
\alias{vip2vivid}
\title{vip2vivid}
\usage{
vip2vivid(importance, interaction, reorder = TRUE)
}
\arguments{
\item{importance}{Measured importance from the vip package using \code{vi} function.}

\item{interaction}{Measured interaction from the vip package using \code{vint} function.}

\item{reorder}{If TRUE (default) uses DendSer to reorder the matrix of interactions and variable importances.}
}
\value{
A matrix of interaction values, with importance on the diagonal.
}
\description{
Takes measured importance and interactions
from the vip package and turns them into a matrix
which can be used for plotting. Accepts any of the variable importance
methods supplied by vip.
}
\examples{
\dontrun{
library(ranger)
library(vip)
aq <- na.omit(airquality) # get data
nameAq <- names(aq[-1]) # get feature names

rF <- ranger(Ozone ~ ., data = aq, importance = "permutation") # create ranger random forest fit
vImp <- vi(rF) # vip importance
vInt <- vint(rF, feature_names = nameAq) # vip interaction

vip2vivid(vImp, vInt)
}
}
