% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_beta_mc.R
\name{racusum_beta_arl_mc}
\alias{racusum_beta_arl_mc}
\title{Compute ARL of RA-CUSUM control charts assuming patient mix with beta distribution using
 Markov chain approximation.}
\usage{
racusum_beta_arl_mc(h, RA, g0, g1, shape1, shape2, r = 600, method = 1, RQ = 1)
}
\arguments{
\item{h}{Double. \code{h} is the control limit (>\code{0}).}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{g0}{Double. Estimated intercept coefficient from a binary logistic regression model.}

\item{g1}{Double. Estimated slope coefficient from a binary logistic regression model.}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{r}{Double. Matrix system dimension.}

\item{method}{Character. If \code{method = "1"} a combination of Sequential Probability Ratio
Test and Toeplitz matrix structure is used to calculate the ARL. \code{"2"} solves a linear
equation system using the classical approach of \emph{Brook and Evans (1972)} to calculate the
ARL.}

\item{RQ}{Double. Defines the performance of a surgeon with the odds ratio ratio of death.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute ARL of risk-adjusted-CUSUM control charts assuming patient mix with beta
distribution using Markov chain approximation.
}
\examples{
\dontrun{
library(vlad)
racusum_beta_arl_mc(h=4.5, RA=2, g0=-3.6798, g1=0.0768*71, shape1=1, shape2=6, r=1e4, method=1)
}
}
\author{
Philipp Wittenberg
}
