dvoigt <-
function(y, mu=0, sigma=1, gamma=1, log = FALSE, complex = FALSE){
	    if (any(c(sigma, gamma) < 0)) 
        stop("sigma and gamma must be positive")
        # erf <- function(x) { 2 * pnorm(x * sqrt(2)) - 1}
 ## (see Abramowitz and Stegun 29.2.29)
 ## and the so-called 'complementary error function'
 #erfc <- function(x) {1 - erf(x)  }  
         cy <- (y - mu + gamma*1i) / (sigma * sqrt(2))
         w<-vector()
 for(j in 1:length(cy)) 
 #w[j] = Re(exp(-cy[j]^2)*erfc(Re(-1i*cy[j])) )# Re(Faddeeva(cy))
 w[j] = exp(-cy[j]^2)*(1-erfz(-1i*cy[j]) )# Re(Faddeeva(cy))
  if(complex){tmp = w/(sigma * sqrt(2*pi))}
  tmp = Re(w) / (sigma * sqrt(2*pi)) 
        #erfc = 2 - 2 * pnorm(Re(-1i*cy)* sqrt(2)) 
        # tmp <- Re(exp(Re(-cy^2))*erfc)/ (sigma * sqrt(2*pi)) 
    if (log) 
        tmp <- exp(tmp)
    tmp
}
# dvoigt examples
# dvoigt(0)
# # 0.2087093
# dnorm(0)
# # 0.3989423
# x = seq(from=-4,to=4, by=0.01)
# plot(x, dvoigt(x), type="l",ylab="",ylim=c(0,0.8))
# lines(x,dvoigt(x,0,1/3,1/3),col="blue")
# lines(x,dnorm(x),lty=2, col="red")
# mtext("dvoigt(x,0,1,1)", adj = 0,col="black")
# mtext("dnorm(x)", adj = 1/2,col="red")
# mtext("dvoigt(x,0,1/3,1/3)", adj = 1,col="blue")

rvoigt <- function(n=1, mu=0, sigma=1, gamma=1){
    if (any(c(sigma,gamma) < 0)) 
        stop("sigma and gamma must be positive")
         rnorm(n, mu, sigma) + rcauchy(n, location =0, scale= gamma)
       }
# rvoigt examples
# rvoigt(1)
# x = rvoigt(n=500)
# head(x)
# q=quantile(x,0.99)
# hist(x[x>-q & x<q], prob=TRUE, breaks=30,ylim=c(0,1.1*dvoigt(0)),main="", xlab="x")
# x.grid = seq(-q,q,by=.1)
# lines(x.grid, dvoigt(x.grid), type="l", ylab="", xlab="",col="red")
# # compare with cauchy and normal
# par(mfrow=c(1,2))
# x = rvoigt(n=500, mu=0,sigma=1,gamma=0.1)
# q=quantile(x,0.99)
# hist(x[x>-q & x<q], prob=TRUE,breaks=20,col="lightgreen",main = "dvoigt(0, 1, 0.1)",xlab="x")
# curve(dnorm(x),lty=1, add=TRUE)

# y = rvoigt(n=500, mu=0,sigma=0.1,gamma=1)
# q=quantile(y,0.99)
# hist(y[y>-q & y<q], prob=TRUE,breaks=25,col="lightblue",main = "dvoigt(0, 0.1, 1)",xlab="x")
# curve(dcauchy(x),lty=1, add=TRUE)
# dev.off()
