% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authenticate.twitter.R
\name{Authenticate.twitter}
\alias{Authenticate.twitter}
\title{Twitter API authentication}
\usage{
\method{Authenticate}{twitter}(
  socialmedia,
  appName,
  apiKey,
  apiSecret,
  accessToken,
  accessTokenSecret,
  bearerToken = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{socialmedia}{Character string. Identifier for social media API to authenticate, set to \code{"twitter"}.}

\item{appName}{Character string. Registered twitter app name associated with the API keys.}

\item{apiKey}{Character string. API consumer key to authenticate (also called API key).}

\item{apiSecret}{Character string. API consumer secret to authenticate (also called API secret).}

\item{accessToken}{Character string. API access token to authenticate.}

\item{accessTokenSecret}{Character string. API access token secret to authenticate.}

\item{bearerToken}{Character string. Twitter app bearer token. Default is \code{NULL}.}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{credential} object containing an access token \code{$auth} and social media type descriptor
\code{$socialmedia} set to \code{"twitter"}. Object has the class names \code{"credential"} and \code{"twitter"}.
}
\description{
Twitter authentication uses OAuth and typically requires four developer API keys generated when you
create a twitter app via the twitter developer web site. These keys and the authentication object produced are
referenced as developer keys and developer access in this package. Software using developer access to the API can
operate with full access to the API including within the user-context but with the understanding that it is an app.
The \pkg{rtweet} package refers to this as bot authentication.

There is another method available commonly used by third-party apps in which an app can be authorized by a user to
use the twitter API on their behalf. The implementation of this method in \pkg{vosonSML} does not require a
developer account but does still require the user to have access to an apps two consumer API keys (generated by the
app developer). The authentication object with token produced from this method allows the user to access the API
within their own user-context and rate-limits.

If an individual has applied for and been granted Twitter API access they will also have a bearer token associated
with their app. This token allows read-only access to the API but higher rate-limits so it is the most suited
method for this package and data collection.

The twitter OAuth process is described here:
\url{https://developer.twitter.com/en/docs/authentication/overview}.
}
\note{
\pkg{vosonSML} uses the \pkg{rtweet} package for twitter data collection and also gratefully acknowledges the
techniques and code written by its authors reproduced in this package for creating twitter API access tokens.
}
\examples{
\dontrun{
# twitter API access using an app bearer token
app_auth <- Authenticate(
  "twitter",
  bearerToken = "xxxxxxxxxxxx"
)

# twitter authentication using developer app API keys
dev_auth <- Authenticate(
  "twitter",
  appName = "My App",
  apiKey = "xxxxxxxxxxxx",
  apiSecret = "xxxxxxxxxxxx",
  accessToken = "xxxxxxxxxxxx",
  accessTokenSecret = "xxxxxxxxxxxx"
)

# twitter user authentication via authorization of an app
# requires the apps consumer API keys apiKey and apiSecret parameters are
# equivalent to the apps consumer key and secret will open a web browser
# to twitter prompting the user to log in and authorize the app
user_auth <- Authenticate(
  "twitter",
  appName = "An App",
  apiKey = "xxxxxxxxxxxx",
  apiSecret = "xxxxxxxxxxxx"
)
}

}
