% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamNIfTI.R
\name{gamNIfTI}
\alias{gamNIfTI}
\title{Wrapper to run a Generalized Additive model on a NIfTI image and output parametric maps}
\usage{
gamNIfTI(image, mask, fourdOut = NULL, formula, subjData,
  mc.preschedule = TRUE, ncores = 1, method = "none", residual = FALSE,
  outDir = NULL, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. Must be a binary mask}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to gam()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{method}{which method of correction for multiple comparisons (default is none)}

\item{residual}{If set to TRUE then residuals maps will be returned along parametric maps}

\item{outDir}{Path to the folder where to output parametric maps (Default is Null, only change if you want to write maps out)}

\item{...}{Additional arguments passed to gam()}
}
\value{
Parametric maps of the fitted models
}
\description{
This function is able to run a Generalized Additive Model (GAM) using the mgcv package. 
The analysis will run in all voxels in in the mask and will return parametric and smooth coefficients.
The function will create parametric maps according to the model selected. 
The function will return a p-map, t-map, z-map, p-adjusted-map for parametric terms and p-map, z-map, p-adjusted-map for smooth terms.
You can select which type of p-value correction you want done on the map.
}
\examples{
image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(0:1, dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), y = rnorm(25))
fm1 <- "~ x + s(y)"
Maps <- gamNIfTI(image=image, mask=mask, 
              formula=fm1, subjData=covs, ncores = 1, method="fdr")
}
