% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_volume.R
\name{volnmf_det}
\alias{volnmf_det}
\title{Update volume-regularized matrix \code{R} using det volume approximation}
\usage{
volnmf_det(
  C,
  X,
  R,
  posit = FALSE,
  w.vol = 0.1,
  eigen.cut = 1e-16,
  err.cut = 0.001,
  n.iter = 1000
)
}
\arguments{
\item{C}{Numeric Matrices. Matrices involved in objective function. Matrix R serves as initialization.}

\item{X}{Numeric Matrices. Matrices involved in objective function. Matrix R serves as initialization.}

\item{R}{Numeric Matrices. Matrices involved in objective function. Matrix R serves as initialization.}

\item{posit}{A boolean. Set up (TRUE) or not (FALSE) non-negative constraints on matrix \code{R}. (default=TRUE)}

\item{w.vol}{A numeric. Volume (det) weight in objective function. (default=0.1)}

\item{eigen.cut}{A numeric. Threshold on eigenvalue of SVD eigenvectors. (default=1e-16)}

\item{err.cut}{A numeric. Stop algorithm if relative erro in R between iteration is less than \code{err.cut}. (default=1e-3)}

\item{n.iter}{An integer. Number of iterations. (default=1e+3)}
}
\value{
An updated matrix \code{R}.
}
\description{
\code{volnmf_det} finds matrix \code{R} that minimizes objective
\code{||X-C*R||^2 + w.vol*det(R)}
}
