% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{formatfunc}
\alias{formatfunc}
\title{Function-returning wrapper for format}
\usage{
formatfunc(
  percent = FALSE,
  prefix = "",
  suffix = "",
  scale = 1,
  digits = NULL,
  nsmall = 0L,
  big.mark = "",
  trim = TRUE,
  scientific = FALSE,
  ...
)
}
\arguments{
\item{percent}{Whether to apply percentage formatting. Set to \code{TRUE} if 1 = 100\%. Or, optionally, set to any other number that represents 100\%. So \code{percent = TRUE} or \code{percent = 1} will interpret \code{.9} as \code{90\%}, or \code{percent = 100} will format \code{90} as \code{90\%}.}

\item{prefix}{A prefix to apply to the formatted number. For example, \code{prefix = '$'} would format \code{4} as \code{$4}.}

\item{suffix}{A suffix to apply to the formatted number. If specified alongside \code{percent}, the suffix comes after the \%.}

\item{scale}{A scalar value to be multiplied by all numbers prior to formatting. \code{scale = 1/1000}, for example, would convert the units into thousands. This is applied before \code{digits}.}

\item{digits}{Number of significant digits.}

\item{nsmall}{The minimum number of digits to the right of the decimal point.}

\item{big.mark}{A character to mark thousands places, for example producing "1,000" instead of "1000".}

\item{trim}{Whether numbers should be trimmed to their own size, rather than being right-justified to a common width. Unlike the actual \code{format()}, this defaults to \code{TRUE}. Note that in most vtable applications, the formatting function is applied one value at a time, rather than to a vector, so \code{trim = FALSE} may not work as intended.}

\item{scientific}{Whether numbers should be encoded in scientific format. Unlike the actual \code{format()}, this defaults to \code{FALSE}.}

\item{...}{Arguments to be passed to \code{format()}. See \code{help(format)}. All other parameters listed above except for \code{percent}, \code{prefix}, or \code{suffix} are also just part of  \code{format}, but may be of particular interest, or have been included to show how defaults have changed.}
}
\description{
This function takes a set of options for the \code{format()} function and returns a function that itself calls \code{format()} with those settings.
}
\details{
The only differences are:

1. \code{scientific} is set to \code{FALSE} by default, and \code{trim} is set to \code{TRUE}
2. Passing a \code{NA} value produces \code{''} instead of \code{'NA'}.
3. In addition to standard \code{format()} options, it also accepts a \code{percent} option to apply percentage formatting, and \code{prefix} and \code{suffix} options to apply prefixes or suffixes to formatted numbers.
4. Has an attribute \code{'big.mark'} storing the \code{'big.mark'} option chosen.

This is in the spirit of the \code{label_} functions in the scales package, except that it uses \code{format()}'s focus on significant digits instead of fixed decimal places, which is good for numbers that range across multiple orders of magnitude, common in \code{sumtable()} and \code{vtable()}.
}
\examples{
x <- c(1, 1000, .000235, 1298.255, NA)
my.formatting.func = formatfunc(digits = 3, prefix = '$')
my.formatting.func(x)

}
