% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft.R
\name{BinomialOutcomeTreatment}
\alias{BinomialOutcomeTreatment}
\title{Stateful object for designing and applying binomial outcome treatments.}
\usage{
BinomialOutcomeTreatment(
  ...,
  var_list,
  outcome_name,
  outcome_target = TRUE,
  cols_to_copy = NULL,
  params = NULL,
  imputation_map = NULL
)
}
\arguments{
\item{...}{not used, force arguments to be specified by name.}

\item{var_list}{Names of columns to treat (effective variables).}

\item{outcome_name}{Name of column holding outcome variable. \code{dframe[[outcomename]]} must be only finite and non-missing values.}

\item{outcome_target}{Value/level of outcome to be considered "success",  and there must be a cut such that \code{dframe[[outcomename]]==outcometarget} at least twice and dframe[[outcomename]]!=outcometarget at least twice.}

\item{cols_to_copy}{list of extra columns to copy.}

\item{params}{parameters list from \code{classification_parameters}}

\item{imputation_map}{map from column names to functions of signature f(values: numeric, weights: numeric), simple missing value imputers.}
}
\description{
Hold settings and results for binomial classification data preparation.
}
\details{
Please see
\url{https://github.com/WinVector/vtreat/blob/master/Examples/fit_transform/fit_transform_api.md},
\code{\link{mkCrossFrameCExperiment}}, 
\code{\link{designTreatmentsC}}, and
\code{\link{prepare.treatmentplan}} for details.
}
