% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_plotly.R
\name{ggplotly_with_legend}
\alias{ggplotly_with_legend}
\title{Make ggplotly and add legend with color as title}
\usage{
ggplotly_with_legend(plot, color, mapping_table)
}
\arguments{
\item{plot}{A ggplot object.}

\item{color}{A string specifying the column name to be used as the color variable.}

\item{mapping_table}{A named list with as name the original colum name and as value the display
name}
}
\value{
A plotly object with a formatted legend.
}
\description{
This function creates a Plotly version of a ggplot2 object and adds a legend with the user-friendly name of the color variable as its title.
}
\examples{
df <- data.frame(x_var = rnorm(100),
                 y_var = rnorm(100),
                 color_var = sample(c("Red", "Blue"),
                 100,
                 replace = TRUE))
xlab_setting <- ggplot2::xlab("x label")
ylab_setting <- ggplot2::ylab("y label")
ggplot_instellingen <- ggplot2::geom_point()
scale_y <- ggplot2::scale_y_continuous()
plot <- basic_plot(df, "x_var", "y_var", "color_var", xlab_setting,
                   ylab_setting, ggplot_instellingen, "none", scale_y)
mapping_table <- list(color_var = "user friendly name var")
plotly_object <- ggplotly_with_legend(plot, "color_var", mapping_table)
}
