

# Define UI for application
shinyUI(tagList(
  shinyjs::useShinyjs(),
  navbarPage(theme=shinythemes::shinytheme('united'), id='tabs', collapsible=TRUE,
                   title='Wallace',
                   tabPanel("Intro", value=0),
                   tabPanel("1 Occ Data", value=1),
                   tabPanel("2 Process Occs", value=2),
                   tabPanel("3 Env Data", value=3),
                   tabPanel("4 Process Envs", value=4),
                   tabPanel("5 Partition Occs", value=5),
                   tabPanel("6 Model", value=6),
                   tabPanel("7 Visualize", value=7),
                   tabPanel("8 Project", value=8),
                   tabPanel("Session Code", value='rmd'),

                   fluidRow(column(4,
                                   wellPanel(
                                     includeCSS(system.file("css", "styles.css", package = "wallace")),
                                     includeScript(system.file("js", "scroll.js", package = "wallace")),
                                     conditionalPanel("input.tabs == 0",
                                                      includeMarkdown(system.file("Rmd", "text_intro_tab.Rmd", package = "wallace"))
                                     ),
                                     # tab 1 ####
                                     conditionalPanel("input.tabs == 1",
                                                      h4("Obtain Occurrence Data"),
                                                      radioButtons("occSel", "Modules Available:",
                                                                   choices = list("Query Database" = 'db', "User-specified Occurrences" = 'user'),
                                                                   selected = 'db'),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.occSel == 'db'",
                                                                       div('Module: Query Database', id="mod"),
                                                                       span('via', id="pkgDes"),
                                                                       span('spocc', id="rpkg"),
                                                                       span('package: Interface to Species Occurrence Data Sources', id="pkgDes"),
                                                                       br(),
                                                                       #                                                                        conditionalPanel("input.togMD1",
                                                                       #                                                                                         includeMarkdown("guidance/tab1_gbif.Rmd")
                                                                       HTML('<hr>'),
                                                                       radioButtons("occDb", "Choose Database:",
                                                                                    choices = list("GBIF" = 'gbif',
                                                                                                   "VertNet" = 'vertnet',
                                                                                                   "BISON" = 'bison')),
                                                                       textInput("spName", label = "Enter species scientific name", placeholder = 'format: Genus species'),
                                                                       shinyBS::bsPopover('spName', title = 'Tip',
                                                                                          'Examples: Felis catus, Canis lupus, Nyctereutes procyonoides',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       actionButton("goName", "Search Database"),
                                                                       br(), br(),
                                                                       sliderInput("occNum", "Maximum number of occurrences:", min = 1, max = 3000, value = 50),
                                                                       shinyBS::bsPopover('occNum', title = 'Tip',
                                                                                          'Maximum number of occurrences recovered from databases. Downloaded records are not sorted randomly: rows are always consistent between downloads.',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       strong("Download database occurrence localities (.csv)"), br(), br(),
                                                                       downloadButton('dlDbOccs', "Download"),
                                                                       HTML('<hr>')
                                                      ),
                                                      conditionalPanel("input.occSel == 'user'",
                                                                       div('Module: User-specified Occurrences', id="mod"),
                                                                       HTML('<hr>'),
                                                                       fileInput("userCSV", label = "Upload Occurrence CSV")),
                                                      conditionalPanel("input.occSel == 'db'",
                                                                       span("spocc", id = "rpkg"), "references", br(),
                                                                       div('Developers: Scott Chamberlain, Karthik Ram, Ted Hart', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/spocc/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href = "https://cran.r-project.org/web/packages/spocc/spocc.pdf", target = "_blank")
                                                      )
                                     ),
                                     # tab 2 ####
                                     conditionalPanel("input.tabs == 2",
                                                      h4("Process Occurrence Data"),
                                                      radioButtons("procOccSel", "Modules Available:",
                                                                   choices = list("Select Localities" = 'selpts',
                                                                                  "Spatial Thin" = 'spthin')),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.procOccSel == 'selpts'",
                                                                       div('Module: Select with Polygon', id="mod"),
                                                                       span('via', id="pkgDes"),
                                                                       span('leaflet', id="rpkg"),
                                                                       span('package: Create Interactive Web Maps with the JavaScript \'Leaflet\'', id="pkgDes"),
                                                                       HTML('<hr>'),
                                                                       numericInput("remLoc", label="Enter the record ID to be removed", value = 0),
                                                                       actionButton("remove", "Remove Locality"),
                                                                       HTML('<hr>'),
                                                                       strong("Select localities on map that overlap with polygon"), br(),
                                                                       "* NOTE: draw polygon by clicking on map", br(), br(),
                                                                       actionButton("selectPoly", "Select Localities"), br(), br(),
                                                                       strong("Reset to original localities and erase polygon"), br(), br()
                                                      ),
                                                      conditionalPanel("input.procOccSel == 'spthin'",
                                                                       div('Module: Spatial Thin', id="mod"),
                                                                       span('via', id="pkgDes"),
                                                                       span('spThin', id="rpkg"),
                                                                       span('package: Spatial Thinning of Species Occurrence Records', id="pkgDes"),
                                                                       HTML('<hr>'),
                                                                       numericInput("thinDist", label = "Thinning distance (km)", value = 0),
                                                                       shinyBS::bsPopover('thinDist', title = 'Tip',
                                                                                          'The minimum distance between occurrence locations (nearest neighbor distance) in km for resulting thinned dataset. Ideally based on species biology (e.g., home-range size).',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       actionButton("goThin", "Thin Localities"), br(), br(),
                                                                       strong("Reset to original localities"), br(), br()

                                                      ),
                                                      actionButton("erasePolySelLocs", "Reset"),
                                                      HTML('<hr>'),
                                                      strong("Download processed occurrence localities (.csv)"), br(), br(),
                                                      downloadButton('dlProcOccCsv', "Download"),
                                                      conditionalPanel("input.procOccSel == 'selpts'",
                                                                       HTML('<hr>'),
                                                                       span("leaflet", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Joe Cheng and Yihui Xie', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/leaflet/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/leaflet/leaflet.pdf", target = "_blank")
                                                      ),
                                                      conditionalPanel("input.procOccSel == 'spthin'",
                                                                       HTML('<hr>'),
                                                                       span("spThin", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Matthew E. Aiello-Lammens, Rob A. Boria, Alex Radosavljevic, Bruno Vilela,
                                                                           Robert P. Anderson', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/spThin/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/spThin/spThin.pdf", target = "_blank"),
                                                                       " | ",
                                                                       a("software note", href="http://onlinelibrary.wiley.com/doi/10.1111/ecog.01132/abstract", target = "_blank")
                                                      )
                                     ),
                                     # tab 3 ####
                                     conditionalPanel("input.tabs == 3",
                                                      h4("Obtain Environmental Data"),
                                                      radioButtons("envSel", "Modules Available:",
                                                                   choices = list("WorldClim")),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.envSel == 'WorldClim'",
                                                                       div('Module: WorldClim', id="mod"),
                                                                       span('via', id="pkgDes"),
                                                                       span('raster', id="rpkg"),
                                                                       span('package: Geographic Data Analysis and Modeling', id="pkgDes"),
                                                                       HTML('<hr>'),
                                                                       selectInput("bcRes", label = "Select WorldClim bioclimatic variable resolution",
                                                                                   choices = list("Select resolution" = "",
                                                                                                  "30 arcsec" = 0.5,
                                                                                                  "2.5 arcmin" = 2.5,
                                                                                                  "5 arcmin" = 5,
                                                                                                  "10 arcmin" = 10)),
                                                                       shinyBS::bsPopover('bcRes', title = 'Tip',
                                                                                          'Approximate lengths at equator: 10 arcmin = ~20 km, 5 arcmin = ~10 km, 2.5 arcmin = ~5 km, 30 arcsec = ~1 km. Exact length varies based on latitudinal position.',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       conditionalPanel('input.bcRes == 0.5',
                                                                                        strong("Using map center coordinates as reference for tile download."),
                                                                                        textOutput('ctrLatLon'), br()
                                                                       ),
                                                                       actionButton("predDnld", "Download Env Data"),
                                                                       # fileInput(inputId = "userPreds", label = "Input predictor rasters", multiple = TRUE),
                                                                       HTML('<hr>')
                                                      ),
                                                      conditionalPanel("input.envSel == 'WorldClim'",
                                                                       span("raster", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Robert J. Hijmans, Jacob van Etten, Joe Cheng, Matteo Mattiuzzu, Michael Sumner, Jonathan A. Greenberg, Oscar Perpinan Lamigueriro, Andrew Bevan, Etienne B. Racine, Ashton Shortridge', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/raster/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/raster/raster.pdf", target = "_blank"),
                                                                       " | ",
                                                                       a("WorldClim", href="http://worldclim.org", target="_blank")
                                                      )
                                     ),
                                     # tab 4 ####
                                     conditionalPanel("input.tabs == 4",
                                                      h4("Process Environmental Data"),
                                                      radioButtons("envProcSel", "Modules Available:",
                                                                   choices = list("Select Study Region" = "backg")),

                                                      HTML('<hr>'),
                                                      conditionalPanel("input.envProcSel == 'backg'",
                                                                       div('Module: Select Study Region', id="mod"),
                                                                       span('via', id="pkgDes"),
                                                                       span('sp', id="rpkg"),
                                                                       span('and', id="pkgDes"),
                                                                       span('rgeos', id="rpkg"),
                                                                       span('packages: Title Classes and Methods for Spatial Data |
                                                                            Interface to Geometry Engine - Open Source (GEOS)', id="pkgDes"),
                                                                       HTML('<hr>'),
                                                                       radioButtons("backgSel", "Background Extents:",
                                                                                    choices = list("Bounding box" = 'bb', "Minimum convex polygon" = 'mcp',
                                                                                                   "User-specified polygon" = 'user'))
                                                      ),
                                                      conditionalPanel("input.backgSel == 'user'",
                                                                       #  shinyFilesButton('userBackg', label='Upload Shapefile', title='Please select a file', multiple=TRUE)),
                                                                       fileInput("userBackg", label = 'Upload polygon with field order: longitude, latitude (.csv)',
                                                                                 accept=c(".csv"), multiple=TRUE)),
                                                      conditionalPanel("input.envProcSel == 'backg' && (input.backgSel == 'bb' || input.backgSel == 'mcp')",
                                                                       numericInput("backgBuf", label = "Study region buffer distance (degree)", value = 0, min = 0, step = 0.5),
                                                                       shinyBS::bsPopover('backgBuf', title = 'Tip',
                                                                                          'Buffer area in degrees (1 degree = ~111 km). Exact length varies based on latitudinal position.',
                                                                                          placement = 'right', options = list(container = "body"))),
                                                      conditionalPanel("input.envProcSel == 'backg'",
                                                                       strong('Mask environmental predictor rasters by polygon'), br(), br(),
                                                                       actionButton("goBackgMask", "Mask"), br(), br(),
                                                                       selectInput('mskPredsFileType', label = "Select File Type",
                                                                                   choices = list("GRD" = 'raster', "ASCII" = 'ascii', "GeoTIFF" = 'GTiff')),
                                                                       strong("Download masked environmental predictors"), br(), br(),
                                                                       downloadButton('downloadMskPreds', "Download"),
                                                                       HTML('<hr>')),
                                                      conditionalPanel("input.envProcSel == 'backg'",
                                                                       span("sp", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Edzer Pebesma, Roger Bivand, Barry Rowlingson, Virgilio Gomez-Rubio,
                                                                           Robert Hijmans, Michael Sumner, Don MacQueen, Jim Lemon, Josh O\'Brien', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/sp/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/sp/sp.pdf", target = "_blank"),
                                                                       p(), span("rgeos", id = "rpkg"), "references", br(),
                                                                       div('rgeos Developers:  Roger Bivand, Colin Rundel, Edzer Pebesma, Karl Ove Hufthammer', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/rgeos/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/rgeos/rgeos.pdf", target = "_blank")
                                                      )

                                     ),
                                     # tab 5 ####
                                     conditionalPanel("input.tabs == 5",
                                                      h4("Partition Occurrence Data"),
                                                      radioButtons("partSel", "Modules Available:",
                                                                   choices = list("Non-spatial Partition" = 'nsp',
                                                                                  "Spatial Partition" = 'sp')),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.partSel == 'sp'",
                                                                       div('Module: Spatial Partition', id="mod")),
                                                      conditionalPanel("input.partSel == 'nsp'",
                                                                       div('Module: Non-spatial Partition', id="mod")),
                                                      conditionalPanel("input.partSel == 'sp' || input.partSel == 'nsp'",
                                                                       span('via', id="pkgDes"),
                                                                       span('ENMeval', id="rpkg"),
                                                                       span('package: Automated Runs and Evaluations of Ecological Niche Models', id="pkgDes"),
                                                                       HTML('<hr>'),
                                                                       selectInput("partSel2", "Options Available:",
                                                                                   choices = list("None selected" = ''))
                                                      ),
                                                      conditionalPanel("input.partSel == 'sp' & (input.partSel2 == 'cb1' | input.partSel2 == 'cb2')",
                                                                       numericInput("aggFact", label = "Aggregation Factor", value = 2, min = 2)),
                                                      conditionalPanel("input.partSel2 == 'random'",
                                                                       numericInput("kfolds", label = "Number of Folds", value = 2, min = 2)),
                                                      # conditionalPanel("input.partSel == 'user'",
                                                      #   br(), br(),
                                                      #   uiOutput('occgrpSel'),
                                                      #   uiOutput('bggrpSel')),
                                                      conditionalPanel("input.partSel == 'sp' || input.partSel == 'nsp'",
                                                                       actionButton("goPart", "Partition"), br(), br(),
                                                                       strong("Download occurrence and background localities with partition values (.csv)"), br(), br(),
                                                                       downloadButton('downloadPart', "Download")
                                                      ),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.partSel == 'sp' || input.partSel == 'nsp'",
                                                                       span("ENMeval", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Robert Muscarella, Peter J. Galante, Mariano Soley-Guardia, Robert A. Boria,
                                                                           Jamie M. Kass, Maria Uriarte, Robert P. Anderson', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/ENMeval/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/ENMeval/ENMeval.pdf", target = "_blank"),
                                                                       " | ",
                                                                       a("software note", href="http://onlinelibrary.wiley.com/doi/10.1111/2041-210X.12261/abstract", target = "_blank")
                                                      )
                                     ),
                                     # tab 6 ####
                                     conditionalPanel("input.tabs == 6",
                                                      h4("Build and Evaluate Niche Model"),
                                                      radioButtons("enmSel", "Modules Available:",
                                                                   choices = list("BIOCLIM", "Maxent")),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.enmSel == 'Maxent'",
                                                                       div('Module: Maxent', id="mod")),
                                                      conditionalPanel("input.enmSel == 'BIOCLIM'",
                                                                       div('Module: BIOCLIM', id="mod")),
                                                      conditionalPanel("input.enmSel == 'BIOCLIM' || input.enmSel == 'Maxent'",
                                                                       span('via', id="pkgDes"),
                                                                       span('ENMeval', id="rpkg"),
                                                                       span('and', id="pkgDes"),
                                                                       span('dismo', id="rpkg"),
                                                                       span('packages: Automated Runs and Evaluations of Ecological Niche Models |
                                                                            Species Distribution Modeling', id="pkgDes")),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.enmSel == 'Maxent'",
                                                                       checkboxGroupInput("fcs", label = "Select feature classes (flexibility of modeled response)",
                                                                                          choices = list("L (Linear)" = "L", "LQ (Linear/Quadratic)" = "LQ", "H (Hinge)" = "H",
                                                                                                         "LQH (Linear/Quadratic/Hinge)" = "LQH", "LQHP (Linear/Quadratic/Hinge/Product)" = "LQHP",
                                                                                                         "LQHPT (Linear/Quadratic/Hinge/Threshold)" = "LQHPT")),
                                                                       shinyBS::bsPopover('fcs', title = 'Tip',
                                                                                          'Feature combinations to be explored. Features are constructed using different relationships within and among the environmental predictors, and are used to constrain the computed probability distribution. In short, more features = more potential model complexity.',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       sliderInput("rms", label = "Select regularization multipliers (penalty against complexity)",
                                                                                   min = 0, max = 10, value = c(1, 2)),
                                                                       shinyBS::bsPopover('rms', title = 'Tip',
                                                                                          'Range of regularization multipliers to explore. Greater values of the regularization multiplier lead to increased penalty against overly complex and/or overfit models. A value of 0 results in no regularization.',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       numericInput("rmsBy", label = "RM step value", value = 1),
                                                                       shinyBS::bsPopover('rmsBy', title = 'Tip',
                                                                                          'Value used to step through regularization multiplier range (e.g. range of 1-3 with step 0.5 results in [1, 1.5, 2, 2.5, 3]).',
                                                                                          placement = 'right', options = list(container = "body"))
                                                      ),
                                                      conditionalPanel("input.enmSel == 'BIOCLIM' || input.enmSel == 'Maxent'",
                                                                       strong("Build and evaluate models"), br(), br(),
                                                                       actionButton("goEval", "Run Models"), br(), br(),
                                                                       strong("Download model results (.csv)"), br(), br(),
                                                                       downloadButton('downloadEvalcsv', "Download")
                                                      ),
                                                      conditionalPanel("input.enmSel == 'BIOCLIM' || input.enmSel == 'Maxent'",
                                                                       HTML('<hr>'),
                                                                       span("ENMeval", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Robert Muscarella, Peter J. Galante, Mariano Soley-Guardia, Robert A. Boria,
                                                                           Jamie M. Kass, Maria Uriarte, Robert P. Anderson', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/ENMeval/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/ENMeval/ENMeval.pdf", target = "_blank"),
                                                                       " | ",
                                                                       a("software note", href="http://onlinelibrary.wiley.com/doi/10.1111/2041-210X.12261/abstract", target = "_blank"), br(),
                                                                       p(), span("dismo", id = "rpkg"), "references", br(),
                                                                       div('Developers:  Robert J. Hijmans, Steven Phillips, John Leathwick, Jane Elith', id="pkgDes"),
                                                                       a("CRAN", href = "http://cran.r-project.org/web/packages/dismo/index.html", target = "_blank"),
                                                                       " | ",
                                                                       a("documentation", href="https://cran.r-project.org/web/packages/dismo/dismo.pdf", target = "_blank")
                                                      )
                                     ),
                                     # tab 7 ####
                                     conditionalPanel("input.tabs == 7",
                                                      h4("Visualize Model Results"),
                                                      radioButtons("visSel", "Modules Available:",
                                                                   choices = list("BIOCLIM Envelope Plots" = 'bcEnvel',
                                                                                  "Maxent Evaluation Plots" = 'mxEval',
                                                                                  "Plot Response Curves" = 'response',
                                                                                  "Map Prediction" = 'map')),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.visSel == 'bcEnvel'",
                                                                       div('Module: BIOCLIM Envelope Plots', id="mod")),
                                                      conditionalPanel("input.visSel == 'mxEval'",
                                                                       div('Module: Maxent Evaluation Plots', id="mod")),
                                                      conditionalPanel("input.visSel == 'response'",
                                                                       div('Module: Response Curves', id="mod")),
                                                      conditionalPanel("input.visSel == 'map'",
                                                                       div('Module: Map Prediction', id="mod")),

                                                      span('via', id="pkgDes"),
                                                      span('ENMeval', id="rpkg"),
                                                      span('and', id="pkgDes"),
                                                      span('dismo', id="rpkg"),
                                                      span('packages: Automated Runs and Evaluations of Ecological Niche Models |
                                                           Species Distribution Modeling', id="pkgDes"),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.visSel == 'map'",
                                                                       uiOutput("modelSelPlotStudyExt"),
                                                                       conditionalPanel("input.enmSel == 'Maxent'",
                                                                                        selectInput('predForm', label = "Prediction output",
                                                                                                    choices = list("raw" = 'raw', "logistic" = 'log'),
                                                                                                    selected = 'log'),
                                                                                        shinyBS::bsPopover('predForm', title = 'Tip',
                                                                                                           'Briefly, raw is "relative occurrence rate" where sum of pixel values is 1, and logistic is interpreted as "probability of presence" where raw values are converted to a value between 0 and 1, with the main assumption that species prevalence is 0.5 (see guidance).',
                                                                                                           placement = 'right', options = list(container = "body"))
                                                                       ),
                                                                       selectInput('predThresh', label = "Set threshold",
                                                                                   choices = list("No threshold" = 'noThresh',
                                                                                                  "Minimum Training Presence" = 'mtp', "10 Percentile Training Presence" = 'p10'),
                                                                                   selected = ''),
                                                                       shinyBS::bsPopover('predThresh', title = 'Tip',
                                                                                          'Create binary map of predicted presence/absence assuming all values above threshold value represent presence. Also can be interpreted as a "potential distribution" (see guidance).',
                                                                                          placement = 'right', options = list(container = "body")),
                                                                       actionButton("plotPred", "Plot Prediction"),
                                                                       br(), br(),
                                                                       selectInput('predFileType', label = "Select File Type",
                                                                                   choices = list("GRD" = 'raster', "ASCII" = 'ascii', "GeoTIFF" = 'GTiff',
                                                                                                  "PNG" = "png")),
                                                                       strong("Download displayed raster"), br(), br(),
                                                                       downloadButton('downloadPred', "Download")
                                                      ),
                                                      conditionalPanel("input.visSel == 'response'",
                                                                       uiOutput("modelSelRespCurv"),
                                                                       uiOutput("predVarSel"),
                                                                       strong("Download response plot (.png)"), br(), br(),
                                                                       downloadButton('downloadRespPlot', "Download")
                                                      ),
                                                      conditionalPanel("input.visSel == 'bcEnvel'",
                                                                       "Pick a bioclimatic variable number for each axis",
                                                                       numericInput("bc1", "Axis 1", value = 1, min = 1, max = 19),
                                                                       numericInput("bc2", "Axis 2", value = 2, min = 1, max = 19),
                                                                       numericInput("bcProb", "Set threshold", value = 0.9, min = 0.75, max = 1, step = 0.05),
                                                                       strong("Download envelope plot (.png)"), br(), br(),
                                                                       downloadButton('downloadEnvPlot', "Download")
                                                      ),
                                                      conditionalPanel("input.visSel == 'mxEval'",
                                                                       selectInput('mxEvalSel', label = "Select Evaluation Plot",
                                                                                   choices = list("Select Stat..." = '', "mean AUC" = 'Mean.AUC', "mean AUC DIFF" = 'Mean.AUC.DIFF', "mean OR MIN" = 'Mean.ORmin',
                                                                                                  "mean OR 10%" = 'Mean.OR10', "delta AICc" = 'delta.AICc')),
                                                                       strong("Download displayed evaluation plot (.png)"), br(), br(),
                                                                       downloadButton('downloadEvalPlot', "Download")
                                                      ),
                                                      HTML('<hr>'),
                                                      span("ENMeval", id = "rpkg"), "references", br(),
                                                      div('Developers:  Robert Muscarella, Peter J. Galante, Mariano Soley-Guardia, Robert A. Boria,
                                                          Jamie M. Kass, Maria Uriarte, Robert P. Anderson', id="pkgDes"),
                                                      a("CRAN", href = "http://cran.r-project.org/web/packages/ENMeval/index.html", target = "_blank"),
                                                      " | ",
                                                      a("documentation", href="https://cran.r-project.org/web/packages/ENMeval/ENMeval.pdf", target = "_blank"),
                                                      " | ",
                                                      a("software note", href="http://onlinelibrary.wiley.com/doi/10.1111/2041-210X.12261/abstract", target = "_blank"), br(),
                                                      p(), span("dismo", id = "rpkg"), "references", br(),
                                                      div('Developers:  Robert J. Hijmans, Steven Phillips, John Leathwick, Jane Elith', id="pkgDes"),
                                                      a("CRAN", href = "http://cran.r-project.org/web/packages/dismo/index.html", target = "_blank"),
                                                      " | ",
                                                      a("documentation", href="https://cran.r-project.org/web/packages/dismo/dismo.pdf", target = "_blank")
                                     ),
                                     # tab 8 ####
                                     conditionalPanel("input.tabs == 8",
                                                      h4("Project Model"),
                                                      radioButtons("projSel", "Modules Available:",
                                                                   choices = list("Project to New Extent" = 'pjArea',
                                                                                  "Project to New Time" = 'pjTime',
                                                                                  "Calculate Environmental Similarity" = 'mess'),
                                                                   # "Project to New Time" = 'pjTime')
                                                                   selected = 'pjArea'),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.projSel == 'pjArea'",
                                                                       div('Module: Project to New Extent', id="mod")),
                                                      conditionalPanel("input.projSel == 'pjTime'",
                                                                       div('Module: Project to New Time', id="mod")),
                                                      conditionalPanel("input.projSel == 'mess'",
                                                                       div('Module: Calculate Environmental Similarity', id="mod")),
                                                      span('via', id="pkgDes"),
                                                      span('dismo', id="rpkg"),
                                                      span('package: Automated Runs and Evaluations of Ecological Niche Models', id="pkgDes"),
                                                      HTML('<hr>'),
                                                      uiOutput("modelSelProj"),
                                                      strong("Select projection extent with polygon | reset and erase polygon "), br(),
                                                      "* NOTE: draw polygon by clicking on map", br(), br(),
                                                      p(actionButton("poly2Sel", "Select"), actionButton("erasePolyProjExt", "Reset")),
                                                      HTML('<hr>'),
                                                      conditionalPanel("input.projSel == 'pjArea'",
                                                                       strong("Project model to current extent"), br(), br(),
                                                                       actionButton('goPjArea', "Project")
                                                      ),
                                                      conditionalPanel("input.projSel == 'mess'",
                                                                       strong("Calculate MESS for current extent"), br(), br(),
                                                                       actionButton('goMESS', "Calculate MESS")
                                                      ),
                                                      conditionalPanel("input.projSel == 'pjTime'",
                                                                       selectInput("selTime", label = "Select time period",
                                                                                   choices = list("Select period" = "",
                                                                                                  # "Last Glacial Maximum (~22,000 years ago)" = 'lgm',
                                                                                                  # "Mid Holocene (~7000 years ago)" = 'mid',
                                                                                                  "2050" = 50,
                                                                                                  "2070" = 70)),
                                                                       uiOutput('selGCM'),
                                                                       # conditionalPanel("input.selTime == 50 || input.selTime == 70",
                                                                       selectInput('selRCP', label = "Select RCP",
                                                                                   choices = list("Select RCP" = "",
                                                                                                  '2.6' = 26,
                                                                                                  '4.5' = 45,
                                                                                                  '6.0' = 60,
                                                                                                  '8.5' = 85)),
                                                                       HTML('<hr>'),
                                                                       strong("Project model to new time for current extent"), br(), br(),
                                                                       actionButton('goPjTime', "Project")
                                                      ),
                                                      br(), br(),
                                                      selectInput('pjFileType', label = "Select File Type",
                                                                  choices = list("GRD" = 'raster', "ASCII" = 'ascii', "GeoTIFF" = 'GTiff',
                                                                                 "PNG" = "png")),
                                                      strong("Download displayed raster"), br(), br(),
                                                      downloadButton('downloadPj', "Download"),
                                                      HTML('<hr>'),
                                                      span("dismo", id = "rpkg"), "references", br(),
                                                      div('Developers:  Robert J. Hijmans, Steven Phillips, John Leathwick, Jane Elith', id="pkgDes"),
                                                      a("CRAN", href = "http://cran.r-project.org/web/packages/dismo/index.html", target = "_blank"),
                                                      " | ",
                                                      a("documentation", href="https://cran.r-project.org/web/packages/dismo/dismo.pdf", target = "_blank")
                                     ),
                                     # session code ####
                                     conditionalPanel("input.tabs == 'rmd'",
                                                      h4("Download Session Code"),
                                                      HTML('<hr>'),
                                                      span('via', id="pkgDes"),
                                                      span('rmarkdown', id="rpkg"),
                                                      span('and', id="pkgDes"),
                                                      span('knitr', id="rpkg"),
                                                      span('packages: Dynamic Documents for R | A General-Purpose Package for Dynamic Report', id="pkgDes"),
                                                      HTML('<hr>'),
                                                      selectInput('mdType', label = "R Markdown Download Type",
                                                                  choices = list("Rmd", "PDF", "HTML", "Word")),
                                                      downloadButton('downloadMD', 'Download Session Code'),
                                                      HTML('<hr>'),
                                                      span("rmarkdown", id = "rpkg"), "references", br(),
                                                      div('Developers:  JJ Allaire, Joe Cheng, Yihui Xie, Jonathan McPherson, Winston Chang, Jeff Allen, Hadley Wickham, Aron Atkins, Rob Hyndman', id="pkgDes"),
                                                      a("CRAN", href = "http://cran.r-project.org/web/packages/rmarkdown/index.html", target = "_blank"),
                                                      " | ",
                                                      a("documentation", href="https://cran.r-project.org/web/packages/rmarkdown/rmarkdown.pdf", target = "_blank"),
                                                      p(), span("knitr", id = "rpkg"), "references", br(),
                                                      div('Developers:  Yihui Xie', id="pkgDes"),
                                                      a("CRAN", href = "http://cran.r-project.org/web/packages/knitr/index.html", target = "_blank"),
                                                      " | ",
                                                      a("documentation", href="https://cran.r-project.org/web/packages/knitr/knitr.pdf", target = "_blank")
                                     )
                                   )
                   ),
                   column(8,
                          conditionalPanel("input.tabs != 0 && input.tabs != 'rmd'",
                                           div(id = "wallaceLog", class = "scrollbox", htmlOutput("log")),
                                           absolutePanel(top = -10, right = 20, width = 150, draggable = TRUE,
                                                         selectInput("bmap", "Change Base Map", choices = c('ESRI Topo'="Esri.WorldTopoMap",
                                                                                                            'Stamen Terrain'="Stamen.Terrain",
                                                                                                            'Open Topo'="OpenTopoMap",
                                                                                                            'ESRI Imagery'="Esri.WorldImagery",
                                                                                                            'ESRI Nat Geo'='Esri.NatGeoWorldMap'),
                                                                     selected = "Esri.WorldTopoMap"))
                          ),
                          br(),
                          conditionalPanel("input.tabs != 'rmd' & input.tabs != 0",
                                           tabsetPanel(id = 'main',
                                                       tabPanel('Map', leaflet::leafletOutput("map", height=600)),
                                                       tabPanel('Occs Tbl', DT::dataTableOutput('occTbl')),
                                                       tabPanel('Results', conditionalPanel("input.tabs == 6", DT::dataTableOutput('evalTbl')),
                                                                conditionalPanel("input.tabs == 7 && input.visSel == 'response'",
                                                                                 imageOutput('respCurv')),
                                                                conditionalPanel("input.tabs == 7 && input.visSel == 'bcEnvel' && input.enmSel == 'BIOCLIM'",
                                                                                 imageOutput('bcEnvelPlot')),
                                                                conditionalPanel("input.tabs == 7 && input.visSel == 'mxEval'  && input.enmSel == 'Maxent'",
                                                                                 imageOutput('mxEvalPlot'))),
                                                       tabPanel('Component Guidance', uiOutput('gtext_comp')),
                                                       tabPanel('Module Guidance', uiOutput('gtext_mod'))
                                           )
                          ),
                          conditionalPanel("input.tabs == 'rmd'",
                                           column(8,
                                                  includeMarkdown(system.file("Rmd", "text_sessionCode.Rmd", package = "wallace"))
                                           )
                          ),
                          conditionalPanel("input.tabs == 0",
                                           tabsetPanel(id = 'introTabs',
                                                       tabPanel('Intro', includeMarkdown(system.file("Rmd", "text_intro.Rmd", package = "wallace"))),
                                                       tabPanel('About',
                                                                fluidRow(
                                                                  column(8,
                                                                         includeMarkdown(system.file("Rmd", "text_about.Rmd", package = "wallace"))
                                                                         )

                                                                )
                                                       )
                                           )
                          )
                   )
                   )
)))
