% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try_na.R
\name{try_na}
\alias{try_na}
\title{Wrapper for "try" function}
\usage{
try_na(expr, silent = TRUE, outFile)
}
\arguments{
\item{expr}{An R expression to try.}

\item{silent}{Logical to control whether the report of error messages is suppressed. Default is \code{TRUE}.}

\item{outFile}{A connection, or a character string naming the file to print to
(via cat(*, file = outFile)); used only if silent is false, as by default.}
}
\value{
Returns an `NA` if any error occurs during the evaluation of a expression.
If not, it will return the result of the evaluation.
}
\description{
\code{try_na} wrapper for \code{\link[base]{try}} function that returns an NA if an error is found.
}
\details{
This is a wrapper on  that returns an `NA` if any error occurs during the evaluation of a expression. See \code{\link[base]{try}} for details.
}
\examples{
{
# try a function that does not exists to produce an error
try_na(crazy78(12))

# try a real function (no error)
try_na(mean(1:5))
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
