% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quer_ml.R
\name{quer_ml}
\alias{quer_ml}
\title{Access Macaulay Library media (meta)data}
\usage{
quer_ml(qword, download = FALSE, X = NULL, file.name = "sciName", media.type = "a",
parallel = 1, path = NULL, pb = TRUE)
}
\arguments{
\item{qword}{Character vector of length one indicating the genus, or genus and
species, to query Macaulay Library database. For example, \emph{Phaethornis} or \emph{Phaethornis longirostris}. More complex queries will be available in the 
future using search terms that follow the Macaulay Library advance query
 syntax.}

\item{download}{Logical argument. If \code{FALSE} only the media file names and
associated metadata are downloaded. If \code{TRUE}, media files are also downloaded to the working
directory. Default is \code{FALSE}. Note that if the file is already found in the 
working directory (as when the downloading process has been interrupted) it will be skipped. 
Hence, resuming downloading processes will not start from scratch.}

\item{X}{Data frame with a 'catalogId' column and any other column listed in the file.name argument. Only the media files listed in the data frame 
will be download (\code{download} argument is automatically set to \code{TRUE}). This can be used to select
the files to be downloaded based on their attributes.}

\item{file.name}{Character vector indicating the tags (or column names) to be included in the sound file names (if download = \code{TRUE}). Several tags can be included. If \code{NULL} only the Macaulay Library catalog identification number ("catalogId") is used. Default is "sciName".}

\item{media.type}{Character vector indicating the type of media that will be searched for. Three options are available:
"a" (audio, default), "v" (video),  and "p" (photo).
Note that "catalogId" is always used (whether or not is listed by users) to avoid duplicated names.}

\item{parallel}{Numeric. Controls whether parallel computing is applied when downloading files.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). Applied both when getting metadata and downloading files.}

\item{path}{Character string containing the directory path where the sound files will be saved. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
If X is not provided the function returns a data frame with detailing media file metadata.
}
\description{
\code{quer_ml} queries media metadata from \href{http://macaulaylibrary.org}{Macaulay Library database}.
}
\details{
This function queries for animal behavior media files at the \href{http://macaulaylibrary.org/}{Macaulay Library, Cornell Lab of Ornithology}. It can return recordings metadata
or download the associated files.
 Files are double-checked after downloading and "empty" files are re-downloaded.
 File downloading process can be interrupted and resume later as long as the 
 working directory is the same. Note that only the first 100 results can be 
 retreived at this time.
 
 Please read carefully \href{https://www.macaulaylibrary.org/macaulay-library-terms-of-use/}{Macaulay Library's terms of use}
 before using any of their data. Users are permitted to:
\itemize{
  \item View Content online.
  \item Print Website pages for non-commercial, personal, educational, and research uses provided that ML is properly cited as the source.
  \item Retain copies of specimen record data in digital form for non-commercial, personal, educational and research purposes provided that ML is properly cited as the source.
  \item Link to and share Website pages from third-party websites for non-commercial, personal, educational and research purposes only provided that ML is properly cited as the source.
  \item Share Content for non-commercial, personal, educational and research purposes provided that ML is properly cited as the source.
  \item Any other uses (including but not limited to commercial, promotional, or administrative uses), reproduction,
  alteration, modification, public performance or display, uploading or posting onto the internet, transmission, 
  redistribution or any other exploitation of the Website or the Content, whether in whole or in part, are prohibited 
  without prior written permission.
}
}
\examples{
\dontrun{
# Set temporary working directory
# setwd(tempdir())

# search without downloading
df1 <- quer_ml(qword = 'Phaethornis squalidus', download = FALSE)
View(df1)

# downloading files
quer_ml(qword = 'Phaethornis squalidus', download = TRUE)

# check folder
open_wd()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{quer_xc}}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
