% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_freq_contour.R
\name{track_freq_contour}
\alias{track_freq_contour}
\title{Spectrograms with frequency measurements}
\usage{
track_freq_contour(X, wl = 512, wl.freq = 512, flim = NULL, wn = "hanning", pal =
  reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2), outer.mar = 
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE, propwidth = FALSE, 
  xl = 1, osci = FALSE, gr = FALSE, sc = FALSE, bp = NULL, cex = c(0.6, 1), 
  threshold = 15, threshold.time = NULL, threshold.freq = NULL, contour = "both", 
  col = c("#E37222B3", "#07889BB3"), pch = c(21, 24),  mar = 0.05, lpos = "topright", 
  it = "jpeg", parallel = 1, path = NULL, img.suffix = NULL, custom.contour = NULL, 
  pb = TRUE, type = "p", leglab = c("Ffreq", "Dfreq"), col.alpha = 0.6, line = TRUE, 
   fast.spec = FALSE, ff.method = "seewave", frange.detec = FALSE, fsmooth = 0.1, 
   widths = c(2, 1), freq.continuity = NULL, clip.edges = 2, track.harm = FALSE, ...)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data frame containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signal (start and end).
The output \code{\link{auto_detec}} can also be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{wl.freq}{A numeric vector of length 1 specifying the window length of the spectrogram
for measurements on the frequency spectrum. Default is 512. Higher values would provide 
more accurate measurements.}

\item{flim}{A numeric vector of length 2 for the frequency limit of 
the spectrogram (in kHz), as in \code{\link[seewave]{spectro}}. Default is \code{NULL}.}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{pal}{A color palette function to be used to assign colors in the 
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2). 
Specifies number of lines in inner plot margins where axis labels fall, 
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0). 
Specifies number of lines in outer plot margins beyond axis labels, with 
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length 1. Controls relative size of 
spectrogram. Default is 1.}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/ 
presentation quality.}

\item{cexlab}{Numeric vector of length 1 specifying the relative size of axis 
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms. 
Default is \code{TRUE}.}

\item{propwidth}{Logical argument to scale the width of spectrogram 
proportionally to duration of the selected call. Default is \code{FALSE}.}

\item{xl}{Numeric vector of length 1. A constant by which to scale 
spectrogram width. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is 
\code{FALSE}.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "frange" to indicate that values in bottom.freq 
and top.freq columns will be used as bandpass limits. Default is \code{NULL}.}

\item{cex}{Numeric vector of length 2, specifies relative size of points 
plotted for frequency measurements and legend font/points, respectively. 
See \code{\link[seewave]{spectro}}.}

\item{threshold}{amplitude threshold (\%) for fundamental and dominant frequency detection as well as frequency range from the spectrum (see 'frange.detec'). Default is 15. WILL BE DEPRECATED. Use 'threshold.time' and 'threshold.time' instead.}

\item{threshold.time}{amplitude threshold (\%) for the time domain. Use for fundamental and dominant frequency detection. If \code{NULL} (default) then the 'threshold' value is used.}

\item{threshold.freq}{amplitude threshold (\%) for the frequency domain. Use for frequency range detection from the spectrum (see 'frange.detec'). If \code{NULL} (default) then the
'threshold' value is used.}

\item{contour}{Character vector, one of "df", "ff" or "both", specifying whether the
dominant or fundamental frequencies or both should be plotted. Default is "both".}

\item{col}{Vector of length 1 or 2 specifying colors of points plotted to mark 
fundamental and dominant frequency measurements respectively (if both are plotted). Default is \code{c("#E37222B3",
"#07889BB3")}. Extreme values (lowest and highest) are highlighted in yellow.}

\item{pch}{Numeric vector of length 1 or 2 specifying plotting characters for 
the frequency measurements. Default is c(21, 24).}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the selections
to set spectrogram limits. Default is 0.05.}

\item{lpos}{Character vector of length 1 or numeric vector of length 2, 
specifying position of legend. If the former, any keyword accepted by 
xy.coords can be used (see below). If the latter, the first value will be the x 
coordinate and the second value the y coordinate for the legend's position.
Default is "topright".}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{img.suffix}{A character vector of length 1 with a suffix (label) to add at the end of the names of 
image files. Default is \code{NULL}.}

\item{custom.contour}{A data frame with frequency contours for exactly the same sound files and selection as in X. 
The frequency values are assumed to be equally spaced in between the start and end of the signal. The 
first 2 columns of the data frame should contain the 'sound.files' and 'selec' columns and should be 
identical to the corresponding columns in X (same order).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{type}{A character vector of length 1 indicating the type of frequency contour plot to be drawn. 
Possible types are "p" for points, "l" for lines and "b" for both.}

\item{leglab}{A character vector of length 1 or 2 containing the label(s) of the frequency contour legend 
in the output image.}

\item{col.alpha}{A numeric vector of length 1  within [0,1] indicating how transparent the lines/points should be.}

\item{line}{Logical argument to add red lines (or box if bottom.freq and top.freq columns are provided) at start and end times of selection. Default is \code{TRUE}.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially 
increases performance (much faster), although some options become unavailable, as collevels, and sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}}, 
\code{\link[monitoR:specCols]{gray.3}}, \code{\link[monitoR:specCols]{topo.1}} and \code{\link[monitoR:specCols]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast' spectrograms. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}}, 
\code{\link[monitoR:specCols]{gray.3}} offer 
decreasing darkness levels.}

\item{ff.method}{Character. Selects the method used to calculate the fundamental
frequency. Either 'tuneR' (using \code{\link[tuneR]{FF}}) or 'seewave' (using 
\code{\link[seewave]{fund}}). Default is 'seewave'. 'tuneR' performs faster (and seems to be more accurate) than 'seewave'.}

\item{frange.detec}{Logical. Controls whether frequency range of signal is automatically 
detected  using the \code{\link{freq_range_detec}} function. If so, the range is used as the 
bandpass filter (overwriting 'bp' argument). Default is \code{FALSE}.}

\item{fsmooth}{A numeric vector of length 1 to smooth the frequency spectrum with a mean
sliding window (in kHz) used for frequency range detection (when \code{frange.detec = TRUE}). This help to average amplitude "hills" to minimize the effect of
amplitude modulation. Default is 0.1.}

\item{widths}{Numeric vector of length 2 to control the relative widths of the spectro (first element) and spectrum (second element,  (when \code{frange.detec = TRUE})).}

\item{freq.continuity}{Numeric vector of length 1 to control whether dominant frequency detections
outliers(i.e that differ from the frequency of the detections right before and after) would be removed. Should be given in kHz. Default is \code{NULL}.}

\item{clip.edges}{Integer vector of length 1 to control if how many 'frequency-wise discontinuous' detection would be remove at the start and end of signals (see 
'freq.continuity' argument). Default is 2. Ignored if \code{freq.continuity = NULL}.}

\item{track.harm}{Logical to control if \code{\link{track_harmonic}} or a modified version of \code{\link[seewave]{dfreq}} is used for dominant frequency detection. Default is \code{FALSE} (use \code{\link[seewave]{dfreq}}).}

\item{...}{Additional arguments to be passed to the internal spectrogram creating function for customizing graphical output. The function is a modified version of \code{\link[seewave]{spectro}}, so it takes the same arguments.}
}
\value{
Spectrograms of the signals listed in the input data frame showing the location of 
the dominant and fundamental frequencies.
}
\description{
\code{track_freq_contour} creates spectrograms to visualize dominant and fundamental frequency measurements (contours)
}
\details{
This function provides visualization of frequency measurements as the ones 
  made by \code{\link{spectro_analysis}}, \code{\link{freq_ts}} and \code{\link{freq_DTW}}. Frequency measures can be made by the function or input by the 
  user (see 'custom.contour' argument). If \code{frange = TRUE} the function uses \code{\link{freq_range_detec}} to detect the frequency range. In this case the graphical output includes a
  frequency spectrum showing the detection threshold. Extreme values (lowest and highest) are highlighted in yellow. 
  Note that, unlike other warbleR functions that measure frequency contours, track_freq_contour do not interpolate frequency values.
}
\examples{
{
#load data
data("Cryp.soui")
writeWave(Cryp.soui, file.path(tempdir(), "Cryp.soui.wav")) #save sound files 

#autodetec location of signals
ad <- auto_detec(threshold = 6, bp = c(1, 3), mindur = 1.2, flim = c(0, 5),
maxdur = 3, img = FALSE, ssmooth = 600, wl = 300, flist = "Cryp.soui.wav", 
path = tempdir())

#track dominant frequency graphs with freq range detection
track_freq_contour(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, 
it = "tiff", bp = c(1, 3), contour = "df", wl = 300, frange = TRUE, 
path = tempdir())

#using users frequency data (custom.contour argument) 
#first get contours using freq_ts
df <- freq_ts(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, img = FALSE,
bp = c(1, 3),  wl = 300, path = tempdir())

# now input the freq_ts output into track_freq_contour         
track_freq_contour(X = ad[!is.na(ad$start),], custom.contour = df ,flim = c(0, 5), ovlp = 90, 
it = "tiff", path = tempdir())

# Check this folder
tempdir()

#track both frequencies 
track_freq_contour(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, 
it = "tiff", bp = c(1, 3), contour = "both", wl = 300, path = tempdir())

}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{spectrograms}} for creating spectrograms from selections,
 \code{\link{snr_spectrograms}} for creating spectrograms to 
  optimize noise margins used in \code{\link{sig2noise}}

Other spectrogram creators: 
\code{\link{color_spectro}()},
\code{\link{freq_DTW}()},
\code{\link{multi_DTW}()},
\code{\link{phylo_spectro}()},
\code{\link{snr_spectrograms}()},
\code{\link{spectrograms}()}
}
\author{
Grace Smith Vidaurre and Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{spectrogram creators}
