% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{create_tour_graph}
\alias{create_tour_graph}
\title{Create a Tour Graph for Warehouse Aisles}
\usage{
create_tour_graph(
  arcs,
  warehouse_width_reduced,
  warehouse_width_actual,
  warehouse_height,
  full_aisles,
  mapping_not_empty
)
}
\arguments{
\item{arcs}{A matrix or data frame representing the arcs (edges) in the warehouse.}

\item{warehouse_width_reduced}{The reduced width of the warehouse.}

\item{warehouse_width_actual}{The actual width of the warehouse.}

\item{warehouse_height}{The height of the warehouse.}

\item{full_aisles}{A logical vector indicating which aisles are full.}

\item{mapping_not_empty}{A vector mapping non-empty aisles.}
}
\value{
A matrix of arcs representing the updated tour graph.
}
\description{
This internal function creates a graph representing a tour through warehouse aisles based on a set of arcs and various parameters like warehouse width and height.
}
\keyword{internal}
