% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_netRadiation.G.R
\name{createAoi}
\alias{createAoi}
\title{Create aoi polygon from topleft and bottomright coordinates}
\usage{
createAoi(topleft, bottomright, EPSG)
}
\arguments{
\item{topleft}{a vector with topleft x,y coordinates}

\item{bottomright}{a vector with bottomright x,y coordinates}

\item{EPSG}{Coordinate reference system EPSG code}
}
\value{
object of class SpatialPolygons
}
\description{
An AOI (Area of Interest) is created based on two points (topleft and bottomright) using a coordinate reference system.
}
\examples{
tl <- c(493300, -3592700)
br <- c(557200, -3700000) 
aoi <- createAoi(topleft = tl, bottomright=br, EPSG=32619)
plot(aoi)
}
\author{
Guillermo Federico Olmedo

Fonseca-Luengo, David
}

