% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{checkSummarizedDataAvailability}
\alias{checkSummarizedDataAvailability}
\title{Quick Check to see if WeatherUnderground has Summarized Weather Data for given station
 for a custom range of dates}
\usage{
checkSummarizedDataAvailability(station_id, start_date, end_date = NULL,
  station_type = "airportCode")
}
\arguments{
\item{station_id}{is a valid 3-letter airport code or a valid Weather Station ID}

\item{start_date}{is a valid string representing a date in the past (YYYY-MM-DD, all numeric)}

\item{end_date}{is a a valid string representing a date in the past (YYYY-MM-DD, all numeric) and is greater than start_date.
Default is NULL, in which case the end_date is taken to the same as the start_date}

\item{station_type}{is either \code{airportCode} or \code{id}}
}
\value{
1 if the Station did have weather records, 0 if nothing was found
}
\description{
Before we attempt to fetch the data for a big time interval of dates, this 
 function is useful to see if the data even exists.
 @details This functions build a custom URL and checks for the data. If available, 
  it will find one row for each date in the date range.
}
\examples{
\dontrun{
data_okay <- checkSummarizedDataAvailability("GIG", 
                                             "2000-01-01",
                                             "2005-12-31")
}
}
