% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{stations_dl}
\alias{stations_dl}
\alias{stations_all}
\title{Get available stations}
\usage{
stations_dl(url = NULL, skip = NULL, verbose = FALSE, quiet = FALSE)
}
\arguments{
\item{url}{Character. Url from which to grab the station information (see
details)}

\item{skip}{Numeric. Number of lines to skip at the beginning of the csv. If
NULL, automatically derived.}

\item{verbose}{Logical. Include progress messages}

\item{quiet}{Logical. Suppress all messages (including messages regarding
missing data, etc.)}
}
\value{
A tibble containing station names, station ID codes and dates of
  operation
}
\description{
This function can be used to download a Station Inventory CSV file from
Environment and Climate Change Canada. This is only necessary if the station
you're interested was only recently added. The 'stations' data set included
in this package contains station data downloaded when the package was last
compiled. This function may take a few minutes to run.
}
\details{
URL defaults to
ftp://client_climate@ftp.tor.ec.gc.ca/Pub/Get_More_Data_Plus_de_donnees/
Station%20Inventory%20EN.csv unless otherwise specified
}
\examples{

\donttest{
 # Update stations data frame
 s <- stations_dl()

 # Use new data frame to search for stations
 stations_search("Winnipeg", stn = s)
}

}
