% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{sum_durations}
\alias{sum_durations}
\title{Summarize visit duration by person}
\usage{
sum_durations(wt, var_duration = NULL, timeframe = NULL, visit_class = NULL)
}
\arguments{
\item{wt}{webtrack data object.}

\item{var_duration}{character. Name of the duration variable if already present.
Defaults to \code{NULL}, in which case duration will be approximated with
\code{add_duration(wt, cutoff = 300, replace_by = "na", replace_val = NULL)}}

\item{timeframe}{character. Indicates for what time frame to aggregate visit durations.
Possible values are \code{"date"}, \code{"week"}, \code{"month"}, \code{"year"}, \code{"wave"} or \code{NULL}.
If set to \code{"wave"}, \code{wt} must contain a column call \code{wave}. Defaults to \code{NULL},
in which case the output contains duration of visits for the entire time.}

\item{visit_class}{character. Column that contains a classification of visits.
For each value in this column, the output will have a column indicating the
number of visits belonging to that value. Defaults to \code{NULL}.}
}
\value{
a data.table with columns \code{panelist_id}, column indicating the time unit
(unless \code{timeframe} set to \code{NULL}), \code{duration_visits} indicating the duration of visits
(in seconds, or whatever the unit of the variable specified by \code{var_duration} parameter),
and a column for each value of \code{visit_class}, if specified.
}
\description{
\code{sum_durations()} summarizes the duration of visits by person within a \code{timeframe},
and optionally by \code{visit_class} of visit. Note:
\itemize{
\item If for a time frame all rows are NA on the duration column, the summarized duration for that time frame will be NA.
\item If only some of the rows of a time frame are NA on the duration column, the function will ignore those NA rows.
\item If there were no visits to a class (i.e., a value of the 'visit_class' column) for a time frame, the summarized duration for that time frame will be zero; if there were visits, but NA on duration, the summarized duration will be NA.
}
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# summarize for whole period
wt_summ <- sum_durations(wt)
# summarize by week
wt_summ <- sum_durations(wt, timeframe = "week")
# create a class variable to summarize by class
wt <- suppressWarnings(extract_domain(wt, drop_na = TRUE))
wt[, google := ifelse(domain == "google.com", 1, 0)]
wt_summ <- sum_durations(wt, timeframe = "week", visit_class = "google")
}
}
