% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_league_dash.R
\name{wnba_leaguedashplayerclutch}
\alias{wnba_leaguedashplayerclutch}
\title{\strong{Get WNBA Stats API League Dashboard by Player Clutch Splits}}
\usage{
wnba_leaguedashplayerclutch(
  ahead_behind = "Ahead or Behind",
  clutch_time = "Last 5 Minutes",
  college = "",
  conference = "",
  country = "",
  date_from = "",
  date_to = "",
  division = "",
  draft_pick = "",
  draft_year = "",
  game_scope = "",
  game_segment = "",
  height = "",
  last_n_games = 0,
  league_id = "10",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  pace_adjust = "N",
  plus_minus = "N",
  point_diff = 5,
  po_round = "",
  per_mode = "Totals",
  period = 0,
  player_experience = "",
  player_position = "",
  rank = "N",
  season = most_recent_wnba_season() - 1,
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  starter_bench = "",
  team_id = "",
  touch_time_range = "",
  vs_conference = "",
  vs_division = "",
  weight = "",
  ...
)
}
\arguments{
\item{ahead_behind}{ahead_behind}

\item{clutch_time}{clutch_time}

\item{college}{college}

\item{conference}{conference}

\item{country}{country}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{draft_pick}{draft_pick}

\item{draft_year}{draft_year}

\item{game_scope}{game_scope}

\item{game_segment}{game_segment}

\item{height}{height}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{pace_adjust}{pace_adjust}

\item{plus_minus}{plus_minus}

\item{point_diff}{point_diff}

\item{po_round}{po_round}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_experience}{player_experience}

\item{player_position}{player_position}

\item{rank}{rank}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{starter_bench}{starter_bench}

\item{team_id}{team_id}

\item{touch_time_range}{touch_time_range}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{weight}{weight}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueDashPlayerClutch

\strong{LeagueDashPlayerClutch}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   NICKNAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   AGE \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
   GP_RANK \tab character \cr
   W_RANK \tab character \cr
   L_RANK \tab character \cr
   W_PCT_RANK \tab character \cr
   MIN_RANK \tab character \cr
   FGM_RANK \tab character \cr
   FGA_RANK \tab character \cr
   FG_PCT_RANK \tab character \cr
   FG3M_RANK \tab character \cr
   FG3A_RANK \tab character \cr
   FG3_PCT_RANK \tab character \cr
   FTM_RANK \tab character \cr
   FTA_RANK \tab character \cr
   FT_PCT_RANK \tab character \cr
   OREB_RANK \tab character \cr
   DREB_RANK \tab character \cr
   REB_RANK \tab character \cr
   AST_RANK \tab character \cr
   TOV_RANK \tab character \cr
   STL_RANK \tab character \cr
   BLK_RANK \tab character \cr
   BLKA_RANK \tab character \cr
   PF_RANK \tab character \cr
   PFD_RANK \tab character \cr
   PTS_RANK \tab character \cr
   PLUS_MINUS_RANK \tab character \cr
   NBA_FANTASY_PTS_RANK \tab character \cr
   DD2_RANK \tab character \cr
   TD3_RANK \tab character \cr
   WNBA_FANTASY_PTS_RANK \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API League Dashboard by Player Clutch Splits}

\strong{Get WNBA Stats API League Dashboard by Player Clutch Splits}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_leaguedashplayerclutch(league_id = '10', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA League Functions: 
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leaguedashteamclutch}()},
\code{\link{wnba_leaguedashteamshotlocations}()},
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_leaguegamefinder}()},
\code{\link{wnba_leaguegamelog}()},
\code{\link{wnba_leaguelineupviz}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_leaguestandingsv3}()},
\code{\link{wnba_shotchartleaguewide}()}

Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA League Functions}
\concept{WNBA Player Functions}
