% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdists.R
\name{Wdensities}
\alias{Wdensities}
\title{Compute densities of weights of evidence in cases and controls}
\usage{
Wdensities(y, posterior.p, prior.p, range.xseq = c(-25, 25),
  x.stepsize = 0.01, adjust.bw = 1, recalibrate = TRUE,
  debug = FALSE)
}
\arguments{
\item{y}{Binary outcome label (0 for controls, 1 for cases).}

\item{posterior.p}{Vector of posterior probabilities generated by using model
to predict on test data.}

\item{prior.p}{Vector of prior probabilities.}

\item{range.xseq}{Range of points where the curves should be sampled.}

\item{x.stepsize}{Distance between each point.}

\item{adjust.bw}{Bandwidth adjustment for the Gaussian kernel density
estimator. By default it is set to 1 (no adjustment), setting it to
a value smaller/larger than 1 reduces/increases the smoothing of
the kernel. This argument is ignored if more than one mixture component
is identified.}

\item{recalibrate}{If \code{TRUE} (the default) the weights of evidence are
calculated after the posterior probabilities have been recalibrated
against \code{y} using a logistic regression model.}

\item{debug}{If \code{TRUE}, the size of the adjustment is reported.}
}
\value{
A densities object that contains the information necessary to compute
summary measures and generate plots.
}
\description{
The function computes smoothed densities of the weight of evidence in
cases and in controls from the crude probabilities, then adjusts them to
make them mathematically consistent so that p(W_ctrl) = exp(-W) p(W_case).
}
\details{
If the sample distributions in cases and controls support a 2-component
mixture model (based on model comparison with BIC) for the densities, this
will be detected and a 2-component mixture model will be fitted before
adjustment.
}
\examples{
data(cleveland)
densities <- with(cleveland, Wdensities(y, posterior.p, prior.p))

# Example which requires fitting a mixture distribution
data(fitonly)
densities <- with(fitonly, Wdensities(y, posterior.p, prior.p))

}
