% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatr-players.R
\name{whatr_players}
\alias{whatr_players}
\title{Who are the players?}
\format{
A tibble with (usually) 3 rows and 4 variables:
\describe{
\item{first}{The contestant's given name.}
\item{last}{The contestant's surname name.}
\item{occupation}{A short description of what the contestant does.}
\item{from}{The city or institution from where the contestant comes.}
}
}
\usage{
whatr_players(game)
}
\arguments{
\item{game}{One of four types of input, all passed to \code{\link[=whatr_html]{whatr_html()}}:
\enumerate{
\item A numeric game ID.
\item Either a 'showgame' or 'showscores' HTML document.
\item A show number character starting with "#".
\item An air date like "yyyy-mm-dd".
}}
}
\value{
A tidy tibble of player info.
}
\description{
\emph{These} individuals compete to score the most points and win the game.
}
\examples{
whatr_players(game = 6304)
}
