% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/livestock.R
\name{get_feed_intake}
\alias{get_feed_intake}
\title{Livestock feed intake}
\usage{
get_feed_intake(version = NULL)
}
\arguments{
\item{version}{File version to use as input. See \link{whep_inputs} for details.}
}
\value{
A tibble with the feed intake data.
It contains the following columns:
\itemize{
\item \code{year}: The year in which the recorded event occurred.
\item \code{area_code}: The code of the country where the data is from. For code
details see e.g. \code{add_area_name()}.
\item \code{live_anim_code}: Commodity balance sheet code for the type of livestock
that is fed. For code details see e.g. \code{add_item_cbs_name()}.
\item \code{item_cbs_code}: The code of the item that is used for feeding the animal.
For code details see e.g. \code{add_item_cbs_name()}.
\item \code{feed_type}: The type of item that is being fed. It can be one of:
\itemize{
\item \code{animals}: Livestock product, e.g. \verb{Bovine Meat}, \verb{Butter, Ghee}, etc.
\item \code{crops}: Crop product, e.g. \verb{Vegetables, Other}, \code{Oats}, etc.
\item \code{residues}: Crop residue, e.g. \code{Straw}, \verb{Fodder legumes}, etc.
\item \code{grass}: Grass, e.g. \code{Grassland}, \verb{Temporary grassland}, etc.
\item \code{scavenging}: Other residues. Single \code{Scavenging} item.
}
\item \code{supply}: The computed amount in tonnes of this item that should be fed to
this animal, when sharing the total item \code{feed} use from the Commodity
Balance Sheet among all livestock.
\item \code{intake}: The actual amount in tonnes that the animal needs, which can be
less than the theoretical used amount from \code{supply}.
\item \code{intake_dry_matter}: The amount specified by \code{intake} but only considering
dry matter, so it should be less than \code{intake}.
\item \code{loss}: The amount that is not used for feed. This is \code{supply - intake}.
\item \code{loss_share}: The percent that is lost. This is \code{loss / supply}.
}
}
\description{
Get amount of items used for feeding livestock.
}
\examples{
# Note: These are smaller samples to show outputs, not the real data.
# For all data, call the function with default version (i.e. no arguments).
get_feed_intake(version = "20250721T143825Z-c1313")
}
