% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocompute.R
\name{write_biocompute}
\alias{write_biocompute}
\title{Create biocompute logs}
\usage{
write_biocompute(queue = run("_whirl.yml"), path = "bco.json", ...)
}
\arguments{
\item{queue}{Result from \code{run()}.}

\item{path}{A character string specifying the file path to write BioCompute log to.}

\item{...}{Additional arguments parsed to \code{jsonlite::write_json()}. Note always uses \code{auto_unbox = TRUE}.}
}
\value{
(\code{invisible}) \code{list} of the biocompute domains and their content.
}
\description{
BioCompute is a standard for logs of programs for for Bioinformatics Computational Analyses.

The BioCompute object is a \code{json} log that can be created based on the output of \code{run()}.
}
\details{
The object consists of the following domains:
\itemize{
\item \strong{Specifications}:
\itemize{
\item \emph{spec_version}: Version of BioCompute used (`https://w3id.org/biocompute/1.3.0/``)
\item \emph{object_id}: Unique project id
\item \emph{type}: Your project type
\item \emph{etag}: Your \code{etag} id from the BioCompute Object Portal
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Provenance-domain}{Provenance Domain}
\itemize{
\item This is used to track the history of the BCO. Review and signatures go here.
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Usability-domain}{Usability Domain}
\itemize{
\item This is used to improve searchability by allowing a free-text description of the BCO.
\item Provide external document.
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Extension-domain}{Extension Domain}
\itemize{
\item This is used to add any additional structured information that is not directly covered by the BCO.
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Description-domain}{Description Domain}
\itemize{
\item Contains a structured field for the description of external references, the pipeline steps,
and the relationship of I/O objects.
\item Provide external document.
\item \strong{Note}: Use of \code{keywords} and \code{External_Reference} entries are not yet implemented.
To use fill out the entries manually after creating the BioCompute object.`
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Execution-domain}{Execution Domain}
\itemize{
\item Contains fields for the execution of the BCO.
\item \strong{Note}: Use of \code{external_data_endpoints} not implemented. Fill out manually afterwards if needed.
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Parametric-domain}{Parametric Domain}
\itemize{
\item Represents the list of parameters customizing the computational flow which can affect
the output of the calculations.
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Iodomain}{IO Domain}
\itemize{
\item Represents the list of global input and output files created by the computational workflow.
}
\item \href{https://wiki.biocomputeobject.org/index.php?title=Error-domain}{Error Domain}
\itemize{
\item Defines the empirical and algorithmic limits and error sources of the BCO.
\item \strong{Note}: Use of this domain is not clearly defined.
It is therefore always left empty in the current implementation.
If you want to add content do so manually after creating the BCO.
}
}

See the \href{https://www.biocomputeobject.org}{BioCompute Object Portal} and the
\href{https://wiki.biocomputeobject.org/Main_Page}{BioCompute Objects Wiki} for more information.
}
