% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis.R
\name{weighted_overlay}
\alias{weighted_overlay}
\title{Weighted overlay}
\usage{
weighted_overlay(factors, weights, output, cost = NULL,
  constraints = NULL, scale_max = 1, verbose_mode = FALSE)
}
\arguments{
\item{factors}{Input factor raster files.}

\item{weights}{Weight values, contained in quotes and separated by commas or semicolons. Must have the same number as factors.}

\item{output}{Output raster file.}

\item{cost}{Weight values, contained in quotes and separated by commas or semicolons. Must have the same number as factors.}

\item{constraints}{Input constraints raster files.}

\item{scale_max}{Suitability scale maximum value (common values are 1.0, 100.0, and 255.0).}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a weighted sum on multiple input rasters after converting each image to a common scale. The tool performs a multi-criteria evaluation (MCE).
}
