% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_shadow_animation}
\alias{wbt_shadow_animation}
\title{Shadow animation}
\usage{
wbt_shadow_animation(
  input,
  output,
  palette = "atlas",
  max_dist = "",
  date = "21/06/2021",
  interval = 15,
  location = "43.5448/-80.2482/-4",
  height = 600,
  delay = 250,
  label = "",
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input digital surface model (DSM) raster file.}

\item{output}{Name of the output HTML file (*.html).}

\item{palette}{DSM image palette; options are 'atlas', 'high_relief', 'arid', 'soft', 'muted', 'light_quant', 'purple', 'viridis', 'gn_yl', 'pi_y_g', 'bl_yl_rd', 'deep', and 'none'.}

\item{max_dist}{Optional maximum search distance, in xy units. Minimum value is 5 x cell size.}

\item{date}{Date in format DD/MM/YYYY.}

\item{interval}{Time interval, in minutes (1-60).}

\item{location}{Location, defined as Lat/Long/UTC-offset (e.g. 43.5448/-80.2482/-4).}

\item{height}{Image height, in pixels.}

\item{delay}{GIF time delay in milliseconds.}

\item{label}{Label text (leave blank for none).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool creates an animated GIF of shadows based on an input DEM.
}
\keyword{GeomorphometricAnalysis}
