% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squarely.R
\name{squarely}
\alias{squarely}
\alias{squarely_}
\title{A special case of the widely adverb for creating tidy
square matrices}
\usage{
squarely(.f, diag = FALSE, upper = TRUE, ...)

squarely_(.f, diag = FALSE, upper = TRUE, ...)
}
\arguments{
\item{.f}{Function to wrap}

\item{diag}{Whether to include diagonal (i = j) in output}

\item{upper}{Whether to include upper triangle, which may be
duplicated}

\item{...}{Extra arguments passed on to \code{widely}}
}
\value{
Returns a function that takes at least four arguments:
  \item{tbl}{A table}
  \item{item}{Name of column to use as rows in wide matrix}
  \item{feature}{Name of column to use as columns in wide matrix}
  \item{feature}{Name of column to use as values in wide matrix}
  \item{...}{Arguments passed on to inner function}
}
\description{
A special case of \code{\link{widely}}. Used to pre-prepare and
post-tidy functions that take an m x n (m items, n features)
matrix and return an m x m (item x item) matrix, such as a
distance or correlation matrix.
}
\examples{

library(dplyr)
library(gapminder)

closest_continent <- gapminder \%>\%
  group_by(continent) \%>\%
  squarely(dist)(country, year, lifeExp)

}
\seealso{
\code{\link{widely}}, \code{\link{pairwise_count}},
\code{\link{pairwise_cor}}, \code{\link{pairwise_dist}}
}
