% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_header_genesis.R
\name{read_header_genesis}
\alias{read_header_genesis}
\title{Read Header of a GENESIS csv}
\usage{
read_header_genesis(
  ...,
  start,
  lines = 2,
  readr_locale = locale(encoding = "windows-1252"),
  replacer = NULL,
  clean_letters = TRUE
)
}
\arguments{
\item{...}{arguments to \code{read_csv2}}

\item{start}{number of the first line of the header}

\item{lines}{number of header lines}

\item{readr_locale}{definition of locale() to be passed to read_csv2()}

\item{replacer}{a vector that is used as the first K column-names}

\item{clean_letters}{make proper variable names? (default: TRUE)}

\item{locale}{default encoding is 'windows-1252'}
}
\value{
a \code{vector} of column names.
}
\description{
\code{read_header_genesis} reads the header of a GENESIS csv.
}
\details{
To generate valid column names, the function replaces all special characters (e.g. German öüä) with ASCII letters 
and removes whitespaces. Multi-line headers are joined but separated with a '_'.
}
\examples{
 \dontrun{
  
 library(readr)
 
 download_csv(tablename="12411-0004")
 
 d <- read_header_genesis('12411-0004.csv', start=6, replacer=c("STAG"))
 data <- read_csv2('12411-0004.csv', skip=6, n_max=30-6+1, 
		na="-", locale=locale(encoding="windows-1252") )
 colnames(data) <- d
  }




}
\seealso{
\code{\link{read_csv2}}
}
