% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvolution.R
\name{plotEvolution}
\alias{plotEvolution}
\title{Plot the evolution of fitness values}
\usage{
plotEvolution(result, ask = TRUE, spar = 0.1)
}
\arguments{
\item{result}{The output matrix of \code{\link{windfarmGA}} or
\code{\link{genAlgo}}, which has stored all relevant information.}

\item{ask}{Should R wait for interaction for subsequent plotting.
Default is TRUE}

\item{spar}{A numeric value determining how exact a spline should
be drawn. Default is 0.1}
}
\description{
Plot the evolution of energy outputs and efficiency rates
over the whole generations. Plots min, mean and max values.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resultrect.rda", package = "windfarmGA"))

## Plot the results of a rectangular grid optimization
result <- resultrect
plotEvolution(result, ask = TRUE, spar = 0.1)
}
}
\author{
Sebastian Gatscha
}
