% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windfarmGA.R
\name{windfarmGA}
\alias{windfarmGA}
\title{Check user input and start an optimization}
\value{
The result is a matrix with aggregated values per generation,
the best individual regarding energy and efficiency per generation,
some fuzzy control variables per generation, a list of all fitness values
per generation, the amount of individuals after each process, a matrix of
all energy, efficiency and fitness values per generation, the selection and 
crossover paramters, a matrix with the generational difference in maximum
and mean energy output, a matrix with the given inputs, a dataframe with
the wind information, the mutation rate per generation and matrix with all 
tested wind farm layouts.
}
\description{
The initiating function of an optimization run which
will interactively check user-inputs. If all inputs are correct,
an optimization will be started.
}
\details{
A terrain effect model can be included in the optimization process.
Therefore, an SRTM elevation model will be downloaded automatically via the
\code{raster::getData} function. A land cover raster can also be downloaded
automatically from the EEA-website, or the path to a raster file can be 
passed to \code{sourceCCL}. The algorithm uses an adapted version of the
Raster legend ("clc_legend.csv"), which is stored in the package directory 
\file{~/inst/extdata}. To use other values for the land cover roughness 
lengths, insert a column named \strong{"Rauhigkeit_z"} to the .csv file, 
assign a surface roughness length to all land cover types. 
Be sure that all rows are filled with numeric values and save the file
with \strong{";"} separation. Assign the path of the file to the 
input variable \code{sourceCCLRoughness} of this function.
}
\seealso{
\code{\link{genAlgo}}
}
\author{
Sebastian Gatscha
}
