% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexa_area.R
\name{hexa_area}
\alias{hexa_area}
\title{Polygon to Hexagonal Grid Tessellation}
\usage{
hexa_area(Polygon1, size, plotTrue = FALSE)
}
\arguments{
\item{Polygon1}{The SpatialPolygons object}

\item{size}{The side length of an hexagon}

\item{plotTrue}{Should the object be plotted}
}
\value{
Returns a list with an indexed matrix of the point coordinates and a
  SpatialPolygons object of the hexagons
}
\description{
The function takes a Polygon and a sizing argument and creates
  a list with an indexed matrix with coordinates and a SpatialPolygons
  object, that consists of hexagonal grids
}
\examples{
library(spatstat)
library(sp)
library(raster)
Polygon1 <- Polygon(rbind(c(4498482, 2668272), c(4498482, 2669343),
                          c(4499991, 2669343), c(4499991, 2668272)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+init=epsg:3035"
proj4string(Polygon1) <- Projection
HexGrid <- hexa_area(Polygon1, 100, TRUE)
plot(HexGrid[[2]])

}
\seealso{
Other Helper Functions: 
\code{\link{dup_coords}()},
\code{\link{getDEM}()},
\code{\link{getISO3}()},
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{isSpatial}()},
\code{\link{permutations}()},
\code{\link{readintegerSel}()},
\code{\link{readinteger}()},
\code{\link{splitAt}()},
\code{\link{tess2SPdf}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
