% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_finites.R
\name{row_finites}
\alias{row_finites}
\alias{row_finites.matrix}
\alias{row_finites.data.frame}
\title{Conditions related to finite values}
\usage{
row_finites(.data, match_type = "none", ...)

\method{row_finites}{matrix}(.data, match_type = "none", ...)

\method{row_finites}{data.frame}(.data, match_type = "none", ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{match_type}{One of ("all", "any", "none", "which_first", "count"). Possibly abbreviated.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{output_class}}{One of ("vector", "list", "data.frame", "matrix"), possibly abbreviated.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
  }}
}
\description{
Conditions related to finite values
}
\examples{

# consistency with R with respect to NA/NaN
df <- data.frame(NaN, NA_real_, NA_complex_, NA_integer_, NA_character_, NA)
sapply(df, is.finite)
row_finites(df, "none")

# complex also supported
mat <- matrix(as.complex(Inf), nrow = 2L, ncol = 2L)
mat[1L] <- 0+0i
row_finites(mat, "any")

}
