% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wood-packages.R
\name{wood_packages}
\alias{wood_packages}
\title{Collect available packages from multiple repositories}
\usage{
wood_packages(repos = "cran")
}
\arguments{
\item{repos}{\code{character()}\cr
A vector of repositories to query. The following values are available:
\itemize{
\item \code{"cran"}, meaning CRAN;
\item \code{"bioc@release"}, meaning Bioconductor, where \code{release} should be replaced
with a valid Bioconductor release code or one of \code{"release"}, \code{"devel"};
\item \code{"github/user"}, meaning GitHub, where \code{user} should be replaced with a
valid user or organization name (e.g. \code{turtletopia});
\item \code{"runiverse@universe"}, meaning R-universe, where \code{universe} should be
replaced with a valid universe name (e.g. \code{turtletopia});
\item \code{"local#index"}, meaning a local library, where \code{index} should be replaced
with an integer index of a library in \code{\link[base:libPaths]{base::.libPaths()}} or an \code{all}
keyword;
\item \code{"core"}, meaning base R packages;
\item a URL if none of the above is matched.
}}
}
\value{
A character vector of available packages.
}
\description{
This function queries the selected repositories for the
available packages and collects the unique occurrences.
}
\examples{
\donttest{
# head() used due to the number of packages in there
head(wood_packages(c("local#all", "bioc@1.7", "cran", "core")))
wood_packages(c("http://www.omegahat.net/R", "runiverse@turtletopia"))
# By default, only CRAN is queried:
head(wood_packages())
}

}
\seealso{
Functions for all repositories:
\code{\link{wood_dependencies}()},
\code{\link{wood_versions}()}

Functions that query available packages:
\code{\link{wood_bioc_packages}()},
\code{\link{wood_core_packages}()},
\code{\link{wood_cran_packages}()},
\code{\link{wood_github_packages}()},
\code{\link{wood_local_packages}()},
\code{\link{wood_runiverse_packages}()},
\code{\link{wood_url_packages}()}
}
\concept{packages}
\concept{wood}
