% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runiverse-version.R
\name{wood_runiverse_version}
\alias{wood_runiverse_version}
\title{Get current package version in one of R universes}
\usage{
wood_runiverse_version(package, universe = "ropensci")
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{universe}{\code{character(1)}\cr
Name of a universe within R-universe, e.g. "ropensci".}
}
\value{
A single string with a version code.
}
\description{
This function queries the selected universe for the code of the
current version of the selected package.
}
\examples{
\donttest{
wood_runiverse_version("targets")
wood_runiverse_version("ggplot2", universe = "tidyverse")
}

}
\seealso{
Functions for R-universe:
\code{\link{wood_runiverse_dependencies}()},
\code{\link{wood_runiverse_packages}()}

Functions that query package versions:
\code{\link{wood_bioc_version}()},
\code{\link{wood_core_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_versions}()},
\code{\link{wood_local_versions}()},
\code{\link{wood_url_version}()},
\code{\link{wood_versions}()}
}
\concept{runiverse}
\concept{versions}
