% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\docType{data}
\name{card}
\alias{card}
\title{card}
\format{A data.frame with 3010 observations on 34 variables:
\itemize{
 \item \strong{id:} person identifier
 \item \strong{nearc2:} =1 if near 2 yr college, 1966
 \item \strong{nearc4:} =1 if near 4 yr college, 1966
 \item \strong{educ:} years of schooling, 1976
 \item \strong{age:} in years
 \item \strong{fatheduc:} father's schooling
 \item \strong{motheduc:} mother's schooling
 \item \strong{weight:} NLS sampling weight, 1976
 \item \strong{momdad14:} =1 if live with mom, dad at 14
 \item \strong{sinmom14:} =1 if with single mom at 14
 \item \strong{step14:} =1 if with step parent at 14
 \item \strong{reg661:} =1 for region 1, 1966
 \item \strong{reg662:} =1 for region 2, 1966
 \item \strong{reg663:} =1 for region 3, 1966
 \item \strong{reg664:} =1 for region 4, 1966
 \item \strong{reg665:} =1 for region 5, 1966
 \item \strong{reg666:} =1 for region 6, 1966
 \item \strong{reg667:} =1 for region 7, 1966
 \item \strong{reg668:} =1 for region 8, 1966
 \item \strong{reg669:} =1 for region 9, 1966
 \item \strong{south66:} =1 if in south in 1966
 \item \strong{black:} =1 if black
 \item \strong{smsa:} =1 in in SMSA, 1976
 \item \strong{south:} =1 if in south, 1976
 \item \strong{smsa66:} =1 if in SMSA, 1966
 \item \strong{wage:} hourly wage in cents, 1976
 \item \strong{enroll:} =1 if enrolled in school, 1976
 \item \strong{KWW:} knowledge world of work score
 \item \strong{IQ:} IQ score
 \item \strong{married:} =1 if married, 1976
 \item \strong{libcrd14:} =1 if lib. card in home at 14
 \item \strong{exper:} age - educ - 6
 \item \strong{lwage:} log(wage)
 \item \strong{expersq:} exper^2
}}
\source{
\url{https://www.cengage.com/cgi-wadsworth/course_products_wp.pl?fid=M20b&product_isbn_issn=9781111531041}
}
\usage{
data('card')
}
\description{
Wooldridge Source: D. Card (1995), Using Geographic Variation in College Proximity to Estimate the Return to Schooling, in Aspects of Labour Market Behavior: Essays in Honour of John Vanderkamp. Ed. L.N. Christophides, E.K. Grant, and R. Swidinsky, 201-222. Toronto: University of Toronto Press. Professor Card kindly provided these data. Data loads lazily.
}
\section{Notes}{
 Computer Exercise C15.3 is important for analyzing these data. There, it is shown that the instrumental variable, `nearc4`, is actually correlated with `IQ`, at least for the subset of men for which an IQ score is reported. However, the correlation between `nearc4`` and `IQ`, once the other explanatory variables are netted out, is arguably zero. At least, it is not statistically different from zero. In other words, `nearc4` fails the exogeneity requirement in a simple regression model but it passes, at least using the crude test described above, if controls are added to the wage equation. For a more advanced course, a nice extension of Card's analysis is to allow the return to education to differ by race. A relatively simple extension is to include black education (blackeduc) as an additional explanatory variable; its natural instrument is blacknearc4.

Used in Text: pages 526-527, 547
}

\examples{
 str(card)
}
\keyword{datasets}
