% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes.R
\name{add_recipe}
\alias{add_recipe}
\title{Add Recipe to Generate Endpoints}
\usage{
add_recipe(
  worcs_directory = ".",
  recipe = "rmarkdown::render('manuscript/manuscript.Rmd')",
  terminal = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{recipe}{Character string, indicating the function call to evaluate in
order to reproduce the endpoints of the WORCS project.}

\item{terminal}{Logical, indicating whether or not to evaluate the \code{recipe}
in the terminal (\code{TRUE}) or in R (\code{FALSE}). Defaults to \code{FALSE}}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: \code{TRUE}}

\item{...}{Additional arguments.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Add a recipe to a WORCS project file to generate its endpoints.
}
\examples{
# Create directory to run the example
if(requireNamespace("withr", quietly = TRUE)){
withr::with_tempdir({
file.create(".worcs")
writeLines("test", "test.txt")
add_recipe()
})
}
}
\seealso{
\code{\link[worcs]{add_endpoint}}
\code{\link[worcs]{snapshot_endpoints}}
\code{\link[worcs]{check_endpoints}}
}
