% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_synthetic.R
\name{add_synthetic}
\alias{add_synthetic}
\title{Add synthetic data to WORCS project}
\usage{
add_synthetic(
  data,
  synthetic_name = paste0("synthetic_", original_name),
  original_name,
  worcs_directory = ".",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the synthetic data.}

\item{synthetic_name}{Character, naming the file synthetic data should be
written to. By
default, prepends \code{"synthetic_"} to the \code{original_name}.}

\item{original_name}{Character, naming an existing data resource in the WORCS
project with which to associate the synthetic \code{data} object.}

\item{worcs_directory}{Character, indicating the WORCS project directory to
which to save data. The default value \code{"."} points to the current
directory.}

\item{verbose}{Logical. Whether or not to print status messages to
the console. Default: TRUE}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
Returns \code{NULL} invisibly. This
function is called for its side effects.
}
\description{
This function adds a user-specified synthetic data resource for
public use to a WORCS project with closed data.
}
\examples{
# Create directory to run the example
old_wd <- getwd()
test_dir <- file.path(tempdir(), "add_synthetic")
dir.create(test_dir)
setwd(test_dir)
worcs:::write_worcsfile(".worcs")
# Prepare data
df <- iris[1:3, ]
# Run closed_data without synthetic
closed_data(df, codebook = NULL, synthetic = FALSE)
# Manually add synthetic
add_synthetic(df, original_name = "df.csv")
# Remove original from file and environment
file.remove("df.csv")
rm(df)
# See that load_data() now loads the synthetic file
load_data()
# Cleaning example directory
setwd(old_wd)
unlink(test_dir, recursive = TRUE)
}
\seealso{
open_data closed_data save_data
}
