% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossling.R
\name{get_crossling_data}
\alias{get_crossling_data}
\title{Get item-by-age summary statistics for items across languages}
\usage{
get_crossling_data(uni_lemmas, mode = "remote")
}
\arguments{
\item{uni_lemmas}{A character vector of uni_lemmas.}

\item{mode}{A string indicating connection mode: one of \code{"local"}, or
\code{"remote"} (defaults to \code{"remote"}).}
}
\value{
A dataframe with a row for each combination of language, item, and
  age, and columns for summary statistics for the group: number of children
  (\code{n_children}), means (\code{comprehension}, \code{production}),
  standard deviations (\code{comprehension_sd}, \code{production_sd}); and
  item-level variables (\code{item_id}, \code{definition}, \code{uni_lemma},
  \code{lexical_category}, \code{lexical_class}).
}
\description{
Get item-by-age summary statistics for items across languages
}
\examples{
\dontrun{
crossling_data <- get_crossling_data(uni_lemmas = c("hat", "nose"))
}
}
