% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_func.R
\name{wormsbymatchnames}
\alias{wormsbymatchnames}
\title{GET AphiaRecordsByMatchNames}
\usage{
wormsbymatchnames(taxon_names, verbose = TRUE, ids = FALSE,
  chunksize = 50, marine_only = "true", sleep_btw_chunks_in_sec = 0.1)
}
\arguments{
\item{taxon_names}{character vector with names of taxa to look up.}

\item{verbose}{be verbose}

\item{ids}{add column "id" and "name" with running id and search names}

\item{chunksize}{only 50 taxa can be looked up per request, so request are split up into chunks (should be 50 or less)}

\item{marine_only}{Limit to marine taxa. Default=true}

\item{sleep_btw_chunks_in_sec}{pause between requests}
}
\value{
a data frame.
}
\description{
takes character vector with taxon names and retrives AphiaRecords from WoRMS
}
\details{
This function will take a character vector with taxon names, 
retrive AphiaRecords (CC-BY) from www.marinespecies.org using the 
GET /AphiaRecordsByName/{ScientificName} Method described at
http://www.marinespecies.org/rest/.
Results will be output to a data.frame with each row being a record.
For each name given, only the one AphiaRecord will be retrived. AphiaRecord with "accepted" status are preferred.
If  not present last entry will be taken which seems to result in best results.
}
