% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/givens.R
\name{givens_full_path}
\alias{givens_full_path}
\title{Construct full interpolated frames}
\usage{
givens_full_path(Fa, Fz, nsteps)
}
\arguments{
\item{Fa}{starting pxd frame}

\item{Fz}{target pxd frame}

\item{nsteps}{number of steps of interpolation}
}
\value{
array with nsteps matrix. Each matrix is interpolated frame in between starting and target frames.
}
\description{
Construct full interpolated frames
}
\examples{
p <- 4
base1 <- tourr::orthonormalise(tourr::basis_random(p, d=1))
base2 <- tourr::orthonormalise(tourr::basis_random(p, d=1))
path <- givens_full_path(base1, base2, nsteps=10)
}
