% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_signals.R
\name{combine_signals}
\alias{combine_signals}
\title{Combine signals from the Hourly Collaboration query}
\usage{
combine_signals(data, hr, signals = c("Emails_sent", "IMs_sent"))
}
\arguments{
\item{data}{Hourly Collaboration query containing signal variables (e.g.
\code{Emails_sent_00_01})}

\item{hr}{Numeric value between 0 to 23 to iterate through}

\item{signals}{Character vector for specifying which signal types to combine.
Defaults to \code{c("Emails_sent", "IMs_sent")}. Other valid values include
\code{"Unscheduled_calls"} and \code{"Meetings"}.}
}
\value{
Returns a numeric vector that represents the sum of signals sent for a given
hour.
}
\description{
Takes in an Hourly Collaboration Data, and for each hour sums and aggregates
the signals (e.g.\code{Emails_sent} and \code{IMs_sent}) in \code{Signals_sent}. This is an
internal function used in the Working Patterns functions.
}
\details{
\code{combine_signals} uses string matching to aggregate columns.
}
\examples{
# Demo using simulated variables
sim_data <-
  data.frame(Emails_sent_09_10 = sample(1:5, size = 10, replace = TRUE),
             Unscheduled_calls_09_10 = sample(1:5, size = 10, replace = TRUE))

combine_signals(sim_data, hr = 9, signals = c("Emails_sent", "Unscheduled_calls"))

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{p_test}()},
\code{\link{pairwise_count}()},
\code{\link{plot_WOE}()},
\code{\link{read_preamble}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{totals_reorder}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
