% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wql-package.R
\name{tsMake}
\alias{tsMake}
\alias{tsMake,WqData-method}
\title{Create time series from water quality data}
\arguments{
\item{object}{Object of class \code{"WqData"}.}

\item{focus}{Name of a site or water quality variable.}

\item{layer}{Number specifying a single depth; a numeric vector of length 2
specifying top and bottom depths of layer; a list specifying multiple depths
and/or layers; or just the string \code{"max.depths"}.}

\item{type}{\code{ts.mon} to get a monthly time series, \code{zoo} to get an
object of class \code{"zoo"} with individual observation dates.}

\item{qprob}{quantile probability, a number between 0 and 1.}
}
\value{
A matrix of class \code{"mts"} or \code{"zoo"}.
}
\description{
Creates a matrix time series object from an object of class \code{"WqData"},
either all variables for a single site or all sites for a single variable.
}
\details{
When \code{qprob = NULL}, the function averages all included depths for each
day, the implicit assumption being that the layer is well-mixed and/or the
samples are evenly distributed with depth in the layer. If \code{layer =
"max.depths"}, then only the value at the maximum depth for each time, site
and variable combination will be used. If no layer is specified, all depths
will be used.

The function produces a matrix time series of all variables for the
specified site or all sites for the specified variable. If \code{type =
"ts.mon"}, available daily data are averaged to produce a monthly time
series, from which a quarterly or annual series can be created if needed. If
you want values for the actual dates of observation, then set \code{type =
"zoo"}.

When \code{qprob} is a number from 0 to 1, it is interpreted as a
probability and the corresponding quantile is used to aggregate observations
within the specified layer. So to get the maximum, for example, use qprob =
1. If \code{type = "ts.mon"}, the same quantile is used to aggregate all the
available daily values.
}
\note{
The layer list is allowed to include negative numbers, which may have
been used in the \code{WqData} object to denote variables that apply to the
water column as a whole, such as, say, -1 for light attenuation coefficient.
This enables \code{focus = 's27'} and \code{layer = list(-1, c(0, 5))} to
produce a time series matrix for station 27 that includes both attenuation
coefficient and chlorophyll averaged over the top 5 m. Negative numbers may
also have been used in the \code{WqData} object to identify qualitative
depths such as \dQuote{near bottom}, which is not uncommon in historical
data sets. So data from such depths can be aggregated easily with other data
to make these time series.
}
\examples{

# Create new WqData object
sfb <- wqData(sfbay, c(1, 3:4), 5:12, site.order = TRUE,
         time.format = "\%m/\%d/\%Y", type = "wide")

# Find means in the 0-10 m layer
y <- tsMake(sfb, focus = 's27', layer = c(0, 10))
plot(y, main = 'Station 27')
# Or select medians in the same layer
y1 <- tsMake(sfb, focus = 's27', layer = c(0, 10), qprob = 0.5)
plot(y1, main = 'Station 27')
# Compare means:medians
apply(y/y1, 2, mean, na.rm=TRUE)

# Combine a layer with a single additional depth
y <- tsMake(sfb, focus = 'chl', layer = list(c(0, 2), 5))
plot(y, main = 'Chlorophyll a, ug/L')

# Use values from the deepest samples
y <- tsMake(sfb, focus = 'dox', layer = "max.depths", type = 'zoo')
head(y)
plot(y, type="h", main = "'Bottom' DO, mg/L")

}
\seealso{
\code{\link{WqData-class}}
}
\keyword{ts}
