% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonAmbiguousMat.R
\name{nonAmbiguousMat}
\alias{nonAmbiguousMat}
\title{Transform matrix to non-ambiguous matrix (in respect to given column)}
\usage{
nonAmbiguousMat(mat, byCol, uniqOnly = FALSE, asList = FALSE,
  nameMod = "amb_", callFrom = NULL)
}
\arguments{
\item{mat}{numeric or character matrix (or data.frame), column specified by 'byCol' must be/will be used as.numeric, 1st column of 'mat' will be considered like index & used for adding prefix 'nameMod' (unless byCol=1, then 2nd col will be used)}

\item{byCol}{(character or integer-index) column by which ambiguousity will be tested}

\item{uniqOnly}{(logical) if =TRUE return unique only, if =FALSE return unique and single representative of non-unique values (with '' added to name), selection of representative of repeated: first (of sorted) or middle if >2 instances}

\item{asList}{(logical) return result as list}

\item{nameMod}{(character) prefix added to 1st column of 'mat' (expect 'by') for indicating non-unique/ambiguous values}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
sorted non-ambigous numeric vector (or list if 'asList'=TRUE and 'uniqOnly'=FALSE)
}
\description{
\code{nonAmbiguousMat} makes values of matrix 'mat' in col 'byCol' unique.
}
\examples{
set.seed(2017); mat2 <- matrix(c(1:100,round(rnorm(200),2)),ncol=3,
  dimnames=list(1:100,LETTERS[1:3]));
head(mat2U <- nonAmbiguousMat(mat2,by="B",na="_",uniqO=FALSE),n=15)
head(get1stOfRepeatedByCol(mat2,sortB="B",sortS="B"))
}
\seealso{
for non-numeric use \code{\link{firstOfRepeated}} - but 1000x much slower !; \code{\link{get1stOfRepeatedByCol}}
}
