% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmSelClu.R
\name{lmSelClu}
\alias{lmSelClu}
\title{Run lm on segmented data (from clustering)}
\usage{
lmSelClu(dat, useCol = 1:2, clu = "max", regTy = "lin",
  filt1 = NULL, filt2 = NULL, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{matrix or data.frame}

\item{useCol}{(integer or charcter) specify which 2 columns of 'dat' to use for linear regression}

\item{clu}{(character) name of cluster to be extracted and treatad}

\item{regTy}{(character) change type used for linear regression :  'lin' for 1st col ~ 2nd col, 'res' for residue ~ 2nd col, 'norRes' for residue/2nd col ~2nd col or 'sqNorRes','inv' for 1st col ~ 1/(2nd col), 'invRes' for residue ~ 1/(2nd col)}

\item{filt1}{(logical or numerical) filter criteria for 1st of 'useCol' , if numeric then select all lines of dat less than max of filt1}

\item{filt2}{(logical or numerical) filter criteria for 2nd of 'useCol' , if numeric then select all lines of dat less than max of filt2}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
lm object (or NULL if no data left)
}
\description{
\code{lmSelClu} runs linear regression on data segmented previously (eg by clustering).  
This functio offers various types of (2-coefficient) linear regression on 2 columns of 'dat' (matrix with 3rd col named 'clu' or 'cluID', numeric elements for cluster-number).
If argument \code{'clu'} is (default) 'max', the column 'clu' will be inspected to take most frequent value of 'clu', otherwise a numeric entry specifying the cluster to extract is expected.
Note: this function was initially made for use with results from diagCheck()
Note: this function lacks means of judging godness of fit of the regression preformed & means for plotting
}
\examples{
set.seed(2016); ran1 <- runif(220)
mat1 <- round(rbind(matrix(c(1:100+ran1[1:100],rep(1,50)),ncol=3), 
  matrix(c(1:60,68:9+ran1[101:160],rep(2,60)),nc=3)),1)
colnames(mat1) <- c("a","BB","clu")
lmSelClu(mat1)
plot(mat1[which(mat1[,3]=="2"),1:2],col=grey(0.6))
abline(lmSelClu(mat1),lty=2,lwd=2)
# 
mat2 <- round(rbind(matrix(c(1:100+ran1[1:100],rep(1,50)),ncol=3), 
  matrix(c(1:60,(2:61+ran1[101:160])^2,rep(2,60)),nc=3)),1)
colnames(mat2) <- c("a","BB","clu")
(reg2 <- lmSelClu(mat2,regTy="sqNor"))
plot(function(x) coef(reg2)[2]+ (coef(reg2)[2]*x^2),xlim=c(1,70))
points(mat2[which(mat2[,3]=="2"),1:2],col=2)
}
\seealso{
\code{\link[stats]{lm}}
}
