% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleFragFig.R
\name{simpleFragFig}
\alias{simpleFragFig}
\title{Simple figure showing line from start- to end-sites of edges (or fragments) defined by their start- and end-sites
 
\code{simpleFragFig} draws figure showing start- and end-sites of edges (or fragments)}
\usage{
simpleFragFig(frag, fullSize = NULL, sortByHead = TRUE,
  useTit = NULL, useCol = NULL, displNa = TRUE, useCex = 0.7)
}
\arguments{
\item{frag}{(matrix) 2 columns defining begin- and end-sites (as interger values)}

\item{fullSize}{(integer) optional max size used for figure (x-axis)}

\item{sortByHead}{(logical) sort by begin-sites (if TRUE) or sort by end-sites}

\item{useTit}{(character) custom title}

\item{useCol}{(character) specify colors, if numeric vector will be onsidered as score values}

\item{displNa}{(character) display names of edges (figure may get crowded)}

\item{useCex}{(numeric) expansion factor}
}
\value{
matrix with mean values
}
\description{
Simple figure showing line from start- to end-sites of edges (or fragments) defined by their start- and end-sites
 
\code{simpleFragFig} draws figure showing start- and end-sites of edges (or fragments)
}
\examples{
frag2 <- cbind(beg=c(2,3,7,13,13,15,7,9,7, 3,7,5,7,3),end=c(6,12,8,18,20,20,19,12,12, 4,12,7,12,4)) 
rownames(frag2) <- c("A","E","B","C","D","F","H","G","I", "J","K","L","M","N")
simpleFragFig(frag2,fullSize=21,sortByHead=TRUE) 
buildTree(frag2)
}
\seealso{
\code{\link{buildTree}}, \code{\link{countSameStartEnd}}, \code{\link{contribToContigPerFrag}},
}
