% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCloseMatch.R
\name{findCloseMatch}
\alias{findCloseMatch}
\title{Find close numeric values between two vectors}
\usage{
findCloseMatch(
  x,
  y,
  compTy = "ppm",
  limit = 5,
  asIndex = FALSE,
  maxFitShort = 100,
  sortMatch = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{numeric vector for comparison}

\item{y}{numeric vector for comparison}

\item{compTy}{(character) may be 'diff' or 'ppm', will be used with threshold from argument 'limit'}

\item{limit}{(numeric) threshold value for retaining values, used with distace-type specified in argument 'compTy'}

\item{asIndex}{(logical) optionally rather report index of retained values}

\item{maxFitShort}{(numeric) limit output to max number of elements (avoid returning high number of results if filtering was not enough stringent)}

\item{sortMatch}{(logical) if TRUE than matching will be preformed as 'match longer (of x & y) to closer', this may process slightly faster (eg 'x' longer: list for each 'y' all 'x' that are close, otherwise list of each 'x'),}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This function returns a list with close matches of 'x' to given 'y', the numeric value dependes on 'sortMatch' (if FASLE then always value of 'y' otherwise of longest of x&y)
}
\description{
\code{findCloseMatch} finds close matches (similar values) between two numeric vectors ('x','y') based on method 'compTy' and threshold 'limit'. 
 Return list with close matches of 'x' to given 'y', the numeric value dependes on 'sortMatch' (if FALSE then always value of 'y' otherwise of longest of x&y).  
 Note: Speed & memory improvement if 'sortMatch'=TRUE (but result might be inversed!): adopt search of x->y or y->x to searching matches of each longest to each shorter  (ie flip x &y).
 Otherwise, if length of 'x' & 'y' are very different, it may be advantagous to use a long(er) 'x'  and short(er) 'y' (with 'sortMatch'=FALSE).  
 Note: Names of 'x' & 'y' or (if no names) prefix letters 'x' & 'y' are always added as names to results.
}
\examples{
aa <- 11:14 ; bb <- c(13.1,11.5,14.3,20:21)
findCloseMatch(aa,bb,com="diff",lim=0.6)
findCloseMatch(c(a=5,b=11,c=12,d=18),c(G=2,H=11,I=12,J=13)+0.5, comp="diff", lim=2)
findCloseMatch(c(4,5,11,12,18),c(2,11,12,13,33)+0.5, comp="diff", lim=2)
findCloseMatch(c(4,5,11,12,18),c(2,11,12,13,33)+0.5, comp="diff", lim=2, sort=FALSE)
.compareByDiff(list(c(a=10,b=11,c=12,d=13),c(H=11,I=12,J=13,K=33)+0.5),limit=1) #' return matrix

a2 <- c(11:20); names(a2) <- letters[11:20]
b2 <- c(25:5)+c(rep(0,5),(1:10)/50000,rep(0,6)); names(b2) <- LETTERS[25:5]
which(abs(b2-a2[8]) < a2[8]*1e-6*5)                                     #'  find R=18 : no10
findCloseMatch(a2, b2, com="ppm", lim=5)                                #'  find Q,R,S,T
findCloseMatch(a2, b2, com="ppm", lim=5,asI=TRUE)                       #'  find Q,R,S,T
findCloseMatch(b2, a2, com="ppm", lim=5,asI=TRUE,sort=FALSE)
findCloseMatch(a2, b2, com="ratio", lim=1.000005)                       #'  find Q,R,S,T
findCloseMatch(a2, b2, com="diff", lim=0.00005)                         #'  find S,T
}
\seealso{
\code{\link{checkSimValueInSer}} and (from this package) \code{.compareByDiff}, for convient output \code{\link{countCloseToLimits}}
}
