% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFilePath.R
\name{checkFilePath}
\alias{checkFilePath}
\title{Verify File-name If Existing (in specified path), If Has Proper Extension Or Select Files With Proper Extension From Given Path}
\usage{
checkFilePath(
  fileName = NULL,
  path = "./",
  expectExt = "",
  mode = "compressedOption",
  compressedOption = NULL,
  strictExtension = NULL,
  stopIfNothing = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{fileName}{(character) name of file to be tested; may also include an absolute or relative path; 
if \code{NULL} and \code{path} as well as \code{expectExt} will take 1st file in given path and proper extension}

\item{path}{(character, length=1) optional separate entry for path of \code{fileName}}

\item{expectExt}{(character) file extension (will not be considered if \code{""})}

\item{mode}{(character) further details if function should give error or warning if no files found
integrates previous argument \code{compressedOption} to also look for look for .gz compressed files; 
\code{strictExtension} to decide if extension (\code{expectExt}) - if given - should be considered obligatory;
\code{stopIfNothing} to stop with error if no files found}

\item{compressedOption}{deprected  (logical) also look for .gz compressed files}

\item{strictExtension}{deprected  (logical) decide if extesion (\code{expectExt}) - if given - should be considered obligatory}

\item{stopIfNothing}{deprected, please use argument \code{mode} instead !}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a character vector with verified file-name(s) (and path), returns \code{NULL} if nothing found - unless \code{mode="stopIfNothing"}
}
\description{
This function allows tesing if a given file-name corresponds to an existing file (eg for reading lateron).
Indications to the path and file-extensions may be given separately. If no files do match .gz compressed versions may be searched, too.
}
\details{
When the filename given by the user exists but it's file-extension is not matching \code{expectExt} 
the argument \code{strictExtension} allows to decide if the filename will still be returned or not.

When \code{expectExt} is given, initial search will look for perfect matches. 
However, if nothing is found and \code{strictExtension=FALSE}, a more relaxed and non-case-sensitive search will be performed.
}
\examples{
(RhomeFi <- list.files(R.home()))
file.exists(file.path(R.home(), "bin"))
checkFilePath(c("xxx","unins000"), R.home(), expectExt="dat")
}
\seealso{
\code{\link[base]{file.exists}}
}
