% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctToUnique.R
\name{correctToUnique}
\alias{correctToUnique}
\title{Correct vector to unique}
\usage{
correctToUnique(
  x,
  sep = "_",
  atEnd = TRUE,
  maxIter = 4,
  NAenum = TRUE,
  callFrom = NULL
)
}
\arguments{
\item{x}{input character vector}

\item{sep}{(character) separator used when adding counter}

\item{atEnd}{(logical) decide location of placing the counter (at end or at beginning of initial text)}

\item{maxIter}{(numeric) max number of iterations}

\item{NAenum}{(logical) if TRUE NAs will be enumerated (NA_1,NA_2,...)}

\item{callFrom}{(character) for better tracking of use of functions}
}
\value{
character vector
}
\description{
\code{correctToUnique} checks 'x' for unique entries, while maintaining the original length. If necessary a counter will added to non-unique entries.
}
\examples{
correctToUnique(c("li0","n",NA,NA,rep(c("li2","li3"),2),rep("n",4))) 
}
\seealso{
\code{\link[base]{unique}} will simply remove repeated elements, ie length of 'x' won't remain constant, \code{\link{filtSizeUniq}} is more complex and slower, \code{\link{treatTxtDuplicates}}
}
