% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeVectors.R
\name{mergeVectors}
\alias{mergeVectors}
\title{Merge Named Vectors}
\usage{
mergeVectors(
  ...,
  namePrefix = "x.",
  NAto0 = FALSE,
  callFrom = NULL,
  silent = FALSE
)
}
\arguments{
\item{...}{all vectors that need to be merged}

\item{namePrefix}{(character) prefix to numers used when vectors are not given with explicit names (second exammple)}

\item{NAto0}{(logical) optional replacemet of \code{NA}s by 0}

\item{callFrom}{(character) allow easier tracking of message produced}

\item{silent}{(logical) suppres messages}
}
\value{
matrix of merged values
}
\description{
This function allows merging for multiple simple named vectors (each element needs to be named).
Basically, all elements carrying the same name across different input-vectors will be ailgned in the same coumn of the output (input-vectors appear as lines).
If vectors are not given using a name (see first example below), they will be names 'x.1' etc (see argument \code{namePrefix}).
}
\details{
Note : The arguments '\code{namePrefix}', '\code{NAto0}', '\code{callFrom}' and '\code{silent}' must be given with full name to be recognized as such (and not get considered as vector for merging).
}
\examples{
x1 <- c(a=1, b=11, c=21)
x2 <- c(b=12, c=22, a=2)
x3 <- c(a=3, d=43)
mergeVectors(vect1=x1, vect2=x2, vect3=x3)
x4 <- 41:44     # no names - not conform for merging
mergeVectors(x1, x2, x3, x4)
}
\seealso{
\code{\link[base]{merge}} (for two data.frames)
}
